/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.InternalServerCnx;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.common.api.proto.ProducerAccessMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalProducer
extends Producer {
    private static final Logger log = LoggerFactory.getLogger(InternalProducer.class);
    private ServerCnx serverCnx;

    public InternalProducer(Topic topic, ServerCnx cnx, long producerId, String producerName) {
        super(topic, (TransportCnx)cnx, producerId, producerName, null, false, null, null, 0L, false, ProducerAccessMode.Shared, Optional.empty(), false);
        this.serverCnx = cnx;
    }

    public CompletableFuture<Void> checkPermissionsAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public void checkPermissions() {
    }

    public CompletableFuture<Void> disconnect() {
        InternalServerCnx cnx = (InternalServerCnx)this.getCnx();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        cnx.getBrokerService().executor().execute(() -> {
            log.info("Disconnecting producer: {}", (Object)this);
            this.getTopic().removeProducer((Producer)this);
            cnx.closeProducer(this);
            future.complete(null);
        });
        return future;
    }

    public ServerCnx getCnx() {
        return this.serverCnx;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

