/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.KafkaRequestHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServerCnx
extends ServerCnx {
    private static final Logger log = LoggerFactory.getLogger(InternalServerCnx.class);
    public static final SocketAddress MOCKED_REMOTE_ADDRESS = new InetSocketAddress("localhost", 9999);
    KafkaRequestHandler kafkaRequestHandler;

    public InternalServerCnx(KafkaRequestHandler kafkaRequestHandler) {
        super(kafkaRequestHandler.getPulsarService());
        this.kafkaRequestHandler = kafkaRequestHandler;
        this.remoteAddress = kafkaRequestHandler.getRemoteAddress();
        if (this.remoteAddress == null) {
            this.remoteAddress = MOCKED_REMOTE_ADDRESS;
        }
    }

    public void closeProducer(Producer producer) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Removed topic: {}'s producer: {}.", new Object[]{this.remoteAddress, producer.getTopic().getName(), producer});
        }
        this.kafkaRequestHandler.close();
    }

    public void updateCtx(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.ctx = this.kafkaRequestHandler.ctx;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public KafkaRequestHandler getKafkaRequestHandler() {
        return this.kafkaRequestHandler;
    }
}

