/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import com.google.common.collect.Sets;
import io.streamnative.pulsar.handlers.kop.AdvertisedListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.kafka.common.record.CompressionType;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.common.configuration.Category;
import org.apache.pulsar.common.configuration.FieldContext;

public class KafkaServiceConfiguration
extends ServiceConfiguration {
    public static final String TENANT_PLACEHOLDER = "${tenant}";
    public static final String TENANT_ALLNAMESPACES_PLACEHOLDER = "*";
    private static final int GroupMinSessionTimeoutMs = 6000;
    private static final int GroupMaxSessionTimeoutMs = 300000;
    private static final int GroupInitialRebalanceDelayMs = 3000;
    private static final int OffsetsRetentionMinutes = 4320;
    private static final int DefaultSystemTopicRetentionSizeInMb = -1;
    public static final int DefaultOffsetsTopicNumPartitions = 50;
    private static final int OffsetsMessageTTL = 259200;
    public static final int DefaultTxnLogTopicNumPartitions = 50;
    public static final int DefaultTxnCoordinatorSchedulerNum = 1;
    public static final int DefaultTxnStateManagerSchedulerNum = 1;
    public static final long DefaultAbortTimedOutTransactionsIntervalMs = TimeUnit.SECONDS.toMillis(10L);
    public static final long DefaultRemoveExpiredTransactionalIdsIntervalMs = TimeUnit.HOURS.toMillis(1L);
    public static final long DefaultTransactionalIdExpirationMs = TimeUnit.DAYS.toMillis(7L);
    @Category
    private static final String CATEGORY_KOP = "Kafka on Pulsar";
    @Category
    private static final String CATEGORY_KOP_SSL = "Kafka on Pulsar SSL configuration";
    @Category
    private static final String CATEGORY_KOP_TRANSACTION = "Kafka on Pulsar transaction";
    @FieldContext(category="Kafka on Pulsar", doc="The number of threads used to respond to the response.")
    private int numSendKafkaResponseThreads = 4;
    @FieldContext(required=true, doc="Manage automatically system namespaces and topic")
    private boolean kafkaManageSystemNamespaces = true;
    @FieldContext(category="Kafka on Pulsar", required=true, doc="Kafka on Pulsar Broker tenant")
    private String kafkaTenant = "public";
    @FieldContext(category="Kafka on Pulsar", required=true, doc="Kafka on Pulsar Broker namespace")
    private String kafkaNamespace = "default";
    @FieldContext(category="Kafka on Pulsar", required=true, doc="The tenant used for storing Kafka metadata topics")
    private String kafkaMetadataTenant = "public";
    @FieldContext(category="Kafka on Pulsar", required=true, doc="Use the current tenant as namespace name for Metadata topics.")
    private boolean kafkaEnableMultiTenantMetadata = true;
    @FieldContext(category="Kafka on Pulsar", required=true, doc="The namespace used for storing Kafka metadata topics")
    private String kafkaMetadataNamespace = "__kafka";
    @FieldContext(category="Kafka on Pulsar", required=true, doc="The namespace used for storing Kafka Schema Registry")
    private String kopSchemaRegistryNamespace = "__kafka_schemaregistry";
    @FieldContext(category="Kafka on Pulsar", doc="The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.")
    private int groupMinSessionTimeoutMs = 6000;
    @FieldContext(category="Kafka on Pulsar", doc="The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.")
    private int groupMaxSessionTimeoutMs = 300000;
    @FieldContext(category="Kafka on Pulsar", doc="The amount of time the group coordinator will wait for more consumers to join a new group before performing  the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.")
    private int groupInitialRebalanceDelayMs = 3000;
    @FieldContext(category="Kafka on Pulsar", doc="Compression codec for the offsets topic - compression may be used to achieve \\\"atomic\\\" commits")
    private String offsetsTopicCompressionCodec = CompressionType.NONE.name();
    @FieldContext(category="Kafka on Pulsar", doc="Number of partitions for the offsets topic")
    private int offsetsTopicNumPartitions = 50;
    @FieldContext(category="Kafka on Pulsar", doc="The maximum size in Bytes for a metadata entry associated with an offset commit")
    private int offsetMetadataMaxSize = 4096;
    @FieldContext(category="Kafka on Pulsar", doc="Offsets older than this retention period will be discarded")
    private long offsetsRetentionMinutes = 4320L;
    @FieldContext(category="Kafka on Pulsar", doc="System topic retention size in mb")
    private int systemTopicRetentionSizeInMB = -1;
    @FieldContext(category="Kafka on Pulsar", doc="Offsets message ttl in seconds. default is 259200.")
    private int offsetsMessageTTL = 259200;
    @FieldContext(category="Kafka on Pulsar", doc="Frequency at which to check for stale offsets")
    private long offsetsRetentionCheckIntervalMs = 600000L;
    @FieldContext(category="Kafka on Pulsar", doc="send queue size of system client to produce system topic.")
    private int kafkaMetaMaxPendingMessages = 10000;
    @FieldContext(category="Kafka on Pulsar", doc="Zookeeper path for storing kop consumer group")
    private String groupIdZooKeeperPath = "/client_group_id";
    @Deprecated
    @FieldContext(category="Kafka on Pulsar", doc="Use `kafkaListeners` instead")
    private String listeners;
    @FieldContext(category="Kafka on Pulsar", doc="Comma-separated list of URIs we will listen on and the listener names.\ne.g. PLAINTEXT://localhost:9092,SSL://localhost:9093.\nEach URI's scheme represents a listener name if `kafkaProtocolMap` is configured.\nOtherwise, the scheme must be a valid protocol in [PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL].\nIf hostname is not set, bind to the default interface.")
    private String kafkaListeners;
    @FieldContext(category="Kafka on Pulsar", doc="Comma-separated map of listener name and protocol.\ne.g. PRIVATE:PLAINTEXT,PRIVATE_SSL:SSL,PUBLIC:PLAINTEXT,PUBLIC_SSL:SSL.\n")
    private String kafkaProtocolMap;
    @FieldContext(category="Kafka on Pulsar", doc="Listeners to publish to ZooKeeper for clients to use.\nThe format is the same as `kafkaListeners`.\n")
    private String kafkaAdvertisedListeners;
    @FieldContext(category="Kafka on Pulsar", doc="limit the queue size for request, \nlike queued.max.requests in kafka.\n")
    private int maxQueuedRequests = 500;
    @FieldContext(category="Kafka on Pulsar", doc="The largest record batch size allowed by Kop, \nlike max.message.bytes in kafka.\n")
    private int maxMessageSize = 0x500000;
    @FieldContext(category="Kafka on Pulsar", doc="limit the timeout for request, \nlike request.timeout.ms in kafka\n")
    private int requestTimeoutMs = 30000;
    @FieldContext(category="Kafka on Pulsar", doc="Idle connections timeout: the server handler close the connections that idle more than this, \nlike connections.max.idle.ms in kafka server.")
    private long connectionMaxIdleMs = 600000L;
    @FieldContext(category="Kafka on Pulsar", doc="Connection close delay on failed authentication: this is the time (in milliseconds) by which connection close will be delayed on authentication failure. ")
    private int failedAuthenticationDelayMs = 300;
    @FieldContext(category="Kafka on Pulsar", doc="The timeout for broker lookups (in milliseconds)")
    private int brokerLookupTimeoutMs = 30000;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_PROTOCOL_CONFIG = \"ssl.protocol\"")
    private String kopSslProtocol = "TLS";
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_PROVIDER_CONFIG = \"ssl.provider\"")
    private String kopSslProvider;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_CIPHER_SUITES_CONFIG = \"ssl.cipher.suites\"")
    private Set<String> kopSslCipherSuites;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_ENABLED_PROTOCOLS_CONFIG = \"ssl.enabled.protocols\"")
    private Set<String> kopSslEnabledProtocols = Sets.newHashSet((Object[])new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"});
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_KEYSTORE_TYPE_CONFIG = \"ssl.keystore.type\"")
    private String kopSslKeystoreType = "JKS";
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Use TLS while connecting to other brokers")
    private boolean kopTlsEnabledWithBroker = false;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_KEYSTORE_LOCATION_CONFIG = \"ssl.keystore.location\"")
    private String kopSslKeystoreLocation;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_KEYSTORE_PASSWORD_CONFIG = \"ssl.keystore.password\"")
    private String kopSslKeystorePassword;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_KEY_PASSWORD_CONFIG = \"ssl.key.password\"")
    private String kopSslKeyPassword;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_TRUSTSTORE_TYPE_CONFIG = \"ssl.truststore.type\"")
    private String kopSslTruststoreType = "JKS";
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_TRUSTSTORE_LOCATION_CONFIG = \"ssl.truststore.location\"")
    private String kopSslTruststoreLocation;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_TRUSTSTORE_PASSWORD_CONFIG = \"ssl.truststore.password\"")
    private String kopSslTruststorePassword;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_KEYMANAGER_ALGORITHM_CONFIG = \"ssl.keymanager.algorithm\"")
    private String kopSslKeymanagerAlgorithm = "SunX509";
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_TRUSTMANAGER_ALGORITHM_CONFIG = \"ssl.trustmanager.algorithm\"")
    private String kopSslTrustmanagerAlgorithm = "SunX509";
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_SECURE_RANDOM_IMPLEMENTATION_CONFIG = \"ssl.secure.random.implementation\"")
    private String kopSslSecureRandomImplementation;
    @FieldContext(category="Kafka on Pulsar SSL configuration", doc="Kafka ssl configuration map with: SSL_CLIENT_AUTH_CONFIG = \"ssl.client.auth\"")
    private String kopSslClientAuth;
    @FieldContext(category="Kafka on Pulsar", doc="supported SASL mechanisms exposed by broker")
    private Set<String> saslAllowedMechanisms = new HashSet<String>();
    @FieldContext(category="Kafka on Pulsar", doc="Maximum number of entries that are read from cursor once per time, default is 5")
    private int maxReadEntriesNum = 5;
    @FieldContext(category="Kafka on Pulsar", doc="The format of an entry. Default: pulsar. Optional: [pulsar, kafka, mixed_kafka]")
    private String entryFormat = "pulsar";
    @FieldContext(category="Kafka on Pulsar", doc="The broker id, default is 1")
    private int kafkaBrokerId = 1;
    @FieldContext(category="Kafka on Pulsar", doc="Store producer id sequence on a Pulsar topic")
    private boolean kafkaTransactionProducerIdsStoredOnPulsar = false;
    @FieldContext(category="Kafka on Pulsar transaction", doc="Flag to enable transaction coordinator")
    private boolean kafkaTransactionCoordinatorEnabled = false;
    @FieldContext(category="Kafka on Pulsar transaction", doc="Number of partitions for the transaction log topic")
    private int kafkaTxnLogTopicNumPartitions = 50;
    @FieldContext(category="Kafka on Pulsar transaction", doc="The interval in milliseconds at which to rollback transactions that have timed out.")
    private long kafkaTxnAbortTimedOutTransactionCleanupIntervalMs = DefaultAbortTimedOutTransactionsIntervalMs;
    @FieldContext(category="Kafka on Pulsar transaction", doc="Whether to enable transactional ID expiration.")
    private boolean kafkaTransactionalIdExpirationEnable = true;
    @FieldContext(category="Kafka on Pulsar transaction", doc="The time (in ms) that the transaction coordinator waits without receiving any transaction status updates for the current transaction before expiring its transactional ID.")
    private long kafkaTransactionalIdExpirationMs = DefaultTransactionalIdExpirationMs;
    @FieldContext(category="Kafka on Pulsar transaction", doc="The interval (in ms) at which to remove expired transactions.")
    private long kafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs = DefaultRemoveExpiredTransactionalIdsIntervalMs;
    @FieldContext(category="Kafka on Pulsar", doc="The fully qualified name of a SASL server callback handler class that implements the AuthenticateCallbackHandler interface, which is used for OAuth2 authentication. If it's not set, the class will be Kafka's default server callback handler for OAUTHBEARER mechanism: KopOAuthBearerUnsecuredValidatorCallbackHandler.")
    private String kopOauth2AuthenticateCallbackHandler;
    @FieldContext(category="Kafka on Pulsar", doc="The properties configuration file of OAuth2 authentication.")
    private String kopOauth2ConfigFile;
    @FieldContext(category="Kafka on Pulsar", doc="KOP Prometheus stats rollover latency")
    private int kopPrometheusStatsLatencyRolloverSeconds = 60;
    @FieldContext(category="Kafka on Pulsar", doc="KOP Enable the group level consumer metrics. (Default: false)")
    private boolean kopEnableGroupLevelConsumerMetrics = false;
    @FieldContext(category="Kafka on Pulsar", doc="The allowed namespaces to list topics with a comma separator.\n For example, \"public/default,public/kafka\".\nIf it's not set or empty, the allowed namespaces will be \"<kafkaTenant>/<kafkaNamespace>\".")
    private Set<String> kopAllowedNamespaces;
    @FieldContext(category="Kafka on Pulsar", doc="Whether to enable the Schema Registry.")
    private boolean kopSchemaRegistryEnable = false;
    @FieldContext(category="Kafka on Pulsar", doc="The name of the topic used by the Schema Registry.")
    private String kopSchemaRegistryTopicName = "__schema-registry";
    @FieldContext(category="Kafka on Pulsar", doc="The Schema Registry port.")
    private int kopSchemaRegistryPort = 8001;
    @FieldContext(category="Kafka on Pulsar", doc="Start the Migration service.")
    private boolean kopMigrationEnable = false;
    @FieldContext(category="Kafka on Pulsar", doc="Migration service port.")
    private int kopMigrationServicePort = 8002;
    @FieldContext(category="Kafka on Pulsar", doc="KOP server compression type. Only used for entryFormat=mixed_kafka. If it's not set to none, the client messages will be used compression type which configured in here.\nThe supported compression types are: [\"none\", \"gzip\", \"snappy\", \"lz4\"]")
    private String kafkaCompressionType = "none";
    @FieldContext(category="Kafka on Pulsar", doc="Whether to skip messages without the index (Kafka offset).\nIt should be enabled if KoP is upgraded from version lower than 2.8.0 to 2.8.0 or higher\nAfter that, the old messages without index will be skipped.")
    private boolean skipMessagesWithoutIndex = false;

    private String checkAdvertisedListeners(String advertisedListeners) {
        StringBuilder listenersReBuilder = new StringBuilder();
        for (String listener : advertisedListeners.split(",")) {
            AdvertisedListener advertisedListener = AdvertisedListener.create(listener);
            String hostname = advertisedListener.getHostname();
            if (hostname.equals("advertisedAddress")) {
                hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)this.getAdvertisedAddress());
                listenersReBuilder.append(advertisedListener.getListenerName()).append("://").append(hostname).append(":").append(advertisedListener.getPort());
            } else {
                listenersReBuilder.append(advertisedListener.getListenerName()).append("://").append(advertisedListener.getHostname()).append(":").append(advertisedListener.getPort());
            }
            listenersReBuilder.append(",");
        }
        return listenersReBuilder.deleteCharAt(listenersReBuilder.lastIndexOf(",")).toString();
    }

    @NonNull
    public String getKafkaAdvertisedListeners() {
        String advertisedListeners = this.getListeners();
        if (this.kafkaAdvertisedListeners != null) {
            advertisedListeners = this.kafkaAdvertisedListeners;
        }
        if (advertisedListeners == null) {
            throw new IllegalStateException("listeners or kafkaListeners is required");
        }
        return this.checkAdvertisedListeners(advertisedListeners);
    }

    public String getListeners() {
        return this.kafkaListeners != null ? this.kafkaListeners : this.listeners;
    }

    @NonNull
    public Properties getKopOauth2Properties() {
        Properties props = new Properties();
        if (this.kopOauth2ConfigFile == null) {
            return props;
        }
        try (FileInputStream inputStream = new FileInputStream(this.kopOauth2ConfigFile);){
            props.load(inputStream);
        }
        catch (FileNotFoundException e) {
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    @NonNull
    public Set<String> getKopAllowedNamespaces() {
        if (this.kopAllowedNamespaces == null || this.kopAllowedNamespaces.isEmpty()) {
            return Collections.singleton("${tenant}/" + this.getKafkaNamespace());
        }
        return this.kopAllowedNamespaces;
    }

    public int getNumSendKafkaResponseThreads() {
        return this.numSendKafkaResponseThreads;
    }

    public boolean isKafkaManageSystemNamespaces() {
        return this.kafkaManageSystemNamespaces;
    }

    public String getKafkaTenant() {
        return this.kafkaTenant;
    }

    public String getKafkaNamespace() {
        return this.kafkaNamespace;
    }

    public String getKafkaMetadataTenant() {
        return this.kafkaMetadataTenant;
    }

    public boolean isKafkaEnableMultiTenantMetadata() {
        return this.kafkaEnableMultiTenantMetadata;
    }

    public String getKafkaMetadataNamespace() {
        return this.kafkaMetadataNamespace;
    }

    public String getKopSchemaRegistryNamespace() {
        return this.kopSchemaRegistryNamespace;
    }

    public int getGroupMinSessionTimeoutMs() {
        return this.groupMinSessionTimeoutMs;
    }

    public int getGroupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    public int getGroupInitialRebalanceDelayMs() {
        return this.groupInitialRebalanceDelayMs;
    }

    public String getOffsetsTopicCompressionCodec() {
        return this.offsetsTopicCompressionCodec;
    }

    public int getOffsetsTopicNumPartitions() {
        return this.offsetsTopicNumPartitions;
    }

    public int getOffsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    public long getOffsetsRetentionMinutes() {
        return this.offsetsRetentionMinutes;
    }

    public int getSystemTopicRetentionSizeInMB() {
        return this.systemTopicRetentionSizeInMB;
    }

    public int getOffsetsMessageTTL() {
        return this.offsetsMessageTTL;
    }

    public long getOffsetsRetentionCheckIntervalMs() {
        return this.offsetsRetentionCheckIntervalMs;
    }

    public int getKafkaMetaMaxPendingMessages() {
        return this.kafkaMetaMaxPendingMessages;
    }

    public String getGroupIdZooKeeperPath() {
        return this.groupIdZooKeeperPath;
    }

    public String getKafkaListeners() {
        return this.kafkaListeners;
    }

    public String getKafkaProtocolMap() {
        return this.kafkaProtocolMap;
    }

    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public long getConnectionMaxIdleMs() {
        return this.connectionMaxIdleMs;
    }

    public int getFailedAuthenticationDelayMs() {
        return this.failedAuthenticationDelayMs;
    }

    public int getBrokerLookupTimeoutMs() {
        return this.brokerLookupTimeoutMs;
    }

    public String getKopSslProtocol() {
        return this.kopSslProtocol;
    }

    public String getKopSslProvider() {
        return this.kopSslProvider;
    }

    public Set<String> getKopSslCipherSuites() {
        return this.kopSslCipherSuites;
    }

    public Set<String> getKopSslEnabledProtocols() {
        return this.kopSslEnabledProtocols;
    }

    public String getKopSslKeystoreType() {
        return this.kopSslKeystoreType;
    }

    public boolean isKopTlsEnabledWithBroker() {
        return this.kopTlsEnabledWithBroker;
    }

    public String getKopSslKeystoreLocation() {
        return this.kopSslKeystoreLocation;
    }

    public String getKopSslKeystorePassword() {
        return this.kopSslKeystorePassword;
    }

    public String getKopSslKeyPassword() {
        return this.kopSslKeyPassword;
    }

    public String getKopSslTruststoreType() {
        return this.kopSslTruststoreType;
    }

    public String getKopSslTruststoreLocation() {
        return this.kopSslTruststoreLocation;
    }

    public String getKopSslTruststorePassword() {
        return this.kopSslTruststorePassword;
    }

    public String getKopSslKeymanagerAlgorithm() {
        return this.kopSslKeymanagerAlgorithm;
    }

    public String getKopSslTrustmanagerAlgorithm() {
        return this.kopSslTrustmanagerAlgorithm;
    }

    public String getKopSslSecureRandomImplementation() {
        return this.kopSslSecureRandomImplementation;
    }

    public String getKopSslClientAuth() {
        return this.kopSslClientAuth;
    }

    public Set<String> getSaslAllowedMechanisms() {
        return this.saslAllowedMechanisms;
    }

    public int getMaxReadEntriesNum() {
        return this.maxReadEntriesNum;
    }

    public String getEntryFormat() {
        return this.entryFormat;
    }

    public int getKafkaBrokerId() {
        return this.kafkaBrokerId;
    }

    public boolean isKafkaTransactionProducerIdsStoredOnPulsar() {
        return this.kafkaTransactionProducerIdsStoredOnPulsar;
    }

    public boolean isKafkaTransactionCoordinatorEnabled() {
        return this.kafkaTransactionCoordinatorEnabled;
    }

    public int getKafkaTxnLogTopicNumPartitions() {
        return this.kafkaTxnLogTopicNumPartitions;
    }

    public long getKafkaTxnAbortTimedOutTransactionCleanupIntervalMs() {
        return this.kafkaTxnAbortTimedOutTransactionCleanupIntervalMs;
    }

    public boolean isKafkaTransactionalIdExpirationEnable() {
        return this.kafkaTransactionalIdExpirationEnable;
    }

    public long getKafkaTransactionalIdExpirationMs() {
        return this.kafkaTransactionalIdExpirationMs;
    }

    public long getKafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs() {
        return this.kafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs;
    }

    public String getKopOauth2AuthenticateCallbackHandler() {
        return this.kopOauth2AuthenticateCallbackHandler;
    }

    public String getKopOauth2ConfigFile() {
        return this.kopOauth2ConfigFile;
    }

    public int getKopPrometheusStatsLatencyRolloverSeconds() {
        return this.kopPrometheusStatsLatencyRolloverSeconds;
    }

    public boolean isKopEnableGroupLevelConsumerMetrics() {
        return this.kopEnableGroupLevelConsumerMetrics;
    }

    public boolean isKopSchemaRegistryEnable() {
        return this.kopSchemaRegistryEnable;
    }

    public String getKopSchemaRegistryTopicName() {
        return this.kopSchemaRegistryTopicName;
    }

    public int getKopSchemaRegistryPort() {
        return this.kopSchemaRegistryPort;
    }

    public boolean isKopMigrationEnable() {
        return this.kopMigrationEnable;
    }

    public int getKopMigrationServicePort() {
        return this.kopMigrationServicePort;
    }

    public String getKafkaCompressionType() {
        return this.kafkaCompressionType;
    }

    public boolean isSkipMessagesWithoutIndex() {
        return this.skipMessagesWithoutIndex;
    }

    public void setNumSendKafkaResponseThreads(int numSendKafkaResponseThreads) {
        this.numSendKafkaResponseThreads = numSendKafkaResponseThreads;
    }

    public void setKafkaManageSystemNamespaces(boolean kafkaManageSystemNamespaces) {
        this.kafkaManageSystemNamespaces = kafkaManageSystemNamespaces;
    }

    public void setKafkaTenant(String kafkaTenant) {
        this.kafkaTenant = kafkaTenant;
    }

    public void setKafkaNamespace(String kafkaNamespace) {
        this.kafkaNamespace = kafkaNamespace;
    }

    public void setKafkaMetadataTenant(String kafkaMetadataTenant) {
        this.kafkaMetadataTenant = kafkaMetadataTenant;
    }

    public void setKafkaEnableMultiTenantMetadata(boolean kafkaEnableMultiTenantMetadata) {
        this.kafkaEnableMultiTenantMetadata = kafkaEnableMultiTenantMetadata;
    }

    public void setKafkaMetadataNamespace(String kafkaMetadataNamespace) {
        this.kafkaMetadataNamespace = kafkaMetadataNamespace;
    }

    public void setKopSchemaRegistryNamespace(String kopSchemaRegistryNamespace) {
        this.kopSchemaRegistryNamespace = kopSchemaRegistryNamespace;
    }

    public void setGroupMinSessionTimeoutMs(int groupMinSessionTimeoutMs) {
        this.groupMinSessionTimeoutMs = groupMinSessionTimeoutMs;
    }

    public void setGroupMaxSessionTimeoutMs(int groupMaxSessionTimeoutMs) {
        this.groupMaxSessionTimeoutMs = groupMaxSessionTimeoutMs;
    }

    public void setGroupInitialRebalanceDelayMs(int groupInitialRebalanceDelayMs) {
        this.groupInitialRebalanceDelayMs = groupInitialRebalanceDelayMs;
    }

    public void setOffsetsTopicCompressionCodec(String offsetsTopicCompressionCodec) {
        this.offsetsTopicCompressionCodec = offsetsTopicCompressionCodec;
    }

    public void setOffsetsTopicNumPartitions(int offsetsTopicNumPartitions) {
        this.offsetsTopicNumPartitions = offsetsTopicNumPartitions;
    }

    public void setOffsetMetadataMaxSize(int offsetMetadataMaxSize) {
        this.offsetMetadataMaxSize = offsetMetadataMaxSize;
    }

    public void setOffsetsRetentionMinutes(long offsetsRetentionMinutes) {
        this.offsetsRetentionMinutes = offsetsRetentionMinutes;
    }

    public void setSystemTopicRetentionSizeInMB(int systemTopicRetentionSizeInMB) {
        this.systemTopicRetentionSizeInMB = systemTopicRetentionSizeInMB;
    }

    public void setOffsetsMessageTTL(int offsetsMessageTTL) {
        this.offsetsMessageTTL = offsetsMessageTTL;
    }

    public void setOffsetsRetentionCheckIntervalMs(long offsetsRetentionCheckIntervalMs) {
        this.offsetsRetentionCheckIntervalMs = offsetsRetentionCheckIntervalMs;
    }

    public void setKafkaMetaMaxPendingMessages(int kafkaMetaMaxPendingMessages) {
        this.kafkaMetaMaxPendingMessages = kafkaMetaMaxPendingMessages;
    }

    public void setGroupIdZooKeeperPath(String groupIdZooKeeperPath) {
        this.groupIdZooKeeperPath = groupIdZooKeeperPath;
    }

    @Deprecated
    public void setListeners(String listeners) {
        this.listeners = listeners;
    }

    public void setKafkaListeners(String kafkaListeners) {
        this.kafkaListeners = kafkaListeners;
    }

    public void setKafkaProtocolMap(String kafkaProtocolMap) {
        this.kafkaProtocolMap = kafkaProtocolMap;
    }

    public void setKafkaAdvertisedListeners(String kafkaAdvertisedListeners) {
        this.kafkaAdvertisedListeners = kafkaAdvertisedListeners;
    }

    public void setMaxQueuedRequests(int maxQueuedRequests) {
        this.maxQueuedRequests = maxQueuedRequests;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setConnectionMaxIdleMs(long connectionMaxIdleMs) {
        this.connectionMaxIdleMs = connectionMaxIdleMs;
    }

    public void setFailedAuthenticationDelayMs(int failedAuthenticationDelayMs) {
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
    }

    public void setBrokerLookupTimeoutMs(int brokerLookupTimeoutMs) {
        this.brokerLookupTimeoutMs = brokerLookupTimeoutMs;
    }

    public void setKopSslProtocol(String kopSslProtocol) {
        this.kopSslProtocol = kopSslProtocol;
    }

    public void setKopSslProvider(String kopSslProvider) {
        this.kopSslProvider = kopSslProvider;
    }

    public void setKopSslCipherSuites(Set<String> kopSslCipherSuites) {
        this.kopSslCipherSuites = kopSslCipherSuites;
    }

    public void setKopSslEnabledProtocols(Set<String> kopSslEnabledProtocols) {
        this.kopSslEnabledProtocols = kopSslEnabledProtocols;
    }

    public void setKopSslKeystoreType(String kopSslKeystoreType) {
        this.kopSslKeystoreType = kopSslKeystoreType;
    }

    public void setKopTlsEnabledWithBroker(boolean kopTlsEnabledWithBroker) {
        this.kopTlsEnabledWithBroker = kopTlsEnabledWithBroker;
    }

    public void setKopSslKeystoreLocation(String kopSslKeystoreLocation) {
        this.kopSslKeystoreLocation = kopSslKeystoreLocation;
    }

    public void setKopSslKeystorePassword(String kopSslKeystorePassword) {
        this.kopSslKeystorePassword = kopSslKeystorePassword;
    }

    public void setKopSslKeyPassword(String kopSslKeyPassword) {
        this.kopSslKeyPassword = kopSslKeyPassword;
    }

    public void setKopSslTruststoreType(String kopSslTruststoreType) {
        this.kopSslTruststoreType = kopSslTruststoreType;
    }

    public void setKopSslTruststoreLocation(String kopSslTruststoreLocation) {
        this.kopSslTruststoreLocation = kopSslTruststoreLocation;
    }

    public void setKopSslTruststorePassword(String kopSslTruststorePassword) {
        this.kopSslTruststorePassword = kopSslTruststorePassword;
    }

    public void setKopSslKeymanagerAlgorithm(String kopSslKeymanagerAlgorithm) {
        this.kopSslKeymanagerAlgorithm = kopSslKeymanagerAlgorithm;
    }

    public void setKopSslTrustmanagerAlgorithm(String kopSslTrustmanagerAlgorithm) {
        this.kopSslTrustmanagerAlgorithm = kopSslTrustmanagerAlgorithm;
    }

    public void setKopSslSecureRandomImplementation(String kopSslSecureRandomImplementation) {
        this.kopSslSecureRandomImplementation = kopSslSecureRandomImplementation;
    }

    public void setKopSslClientAuth(String kopSslClientAuth) {
        this.kopSslClientAuth = kopSslClientAuth;
    }

    public void setSaslAllowedMechanisms(Set<String> saslAllowedMechanisms) {
        this.saslAllowedMechanisms = saslAllowedMechanisms;
    }

    public void setMaxReadEntriesNum(int maxReadEntriesNum) {
        this.maxReadEntriesNum = maxReadEntriesNum;
    }

    public void setEntryFormat(String entryFormat) {
        this.entryFormat = entryFormat;
    }

    public void setKafkaBrokerId(int kafkaBrokerId) {
        this.kafkaBrokerId = kafkaBrokerId;
    }

    public void setKafkaTransactionProducerIdsStoredOnPulsar(boolean kafkaTransactionProducerIdsStoredOnPulsar) {
        this.kafkaTransactionProducerIdsStoredOnPulsar = kafkaTransactionProducerIdsStoredOnPulsar;
    }

    public void setKafkaTransactionCoordinatorEnabled(boolean kafkaTransactionCoordinatorEnabled) {
        this.kafkaTransactionCoordinatorEnabled = kafkaTransactionCoordinatorEnabled;
    }

    public void setKafkaTxnLogTopicNumPartitions(int kafkaTxnLogTopicNumPartitions) {
        this.kafkaTxnLogTopicNumPartitions = kafkaTxnLogTopicNumPartitions;
    }

    public void setKafkaTxnAbortTimedOutTransactionCleanupIntervalMs(long kafkaTxnAbortTimedOutTransactionCleanupIntervalMs) {
        this.kafkaTxnAbortTimedOutTransactionCleanupIntervalMs = kafkaTxnAbortTimedOutTransactionCleanupIntervalMs;
    }

    public void setKafkaTransactionalIdExpirationEnable(boolean kafkaTransactionalIdExpirationEnable) {
        this.kafkaTransactionalIdExpirationEnable = kafkaTransactionalIdExpirationEnable;
    }

    public void setKafkaTransactionalIdExpirationMs(long kafkaTransactionalIdExpirationMs) {
        this.kafkaTransactionalIdExpirationMs = kafkaTransactionalIdExpirationMs;
    }

    public void setKafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs(long kafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs) {
        this.kafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs = kafkaTransactionsRemoveExpiredTransactionalIdCleanupIntervalMs;
    }

    public void setKopOauth2AuthenticateCallbackHandler(String kopOauth2AuthenticateCallbackHandler) {
        this.kopOauth2AuthenticateCallbackHandler = kopOauth2AuthenticateCallbackHandler;
    }

    public void setKopOauth2ConfigFile(String kopOauth2ConfigFile) {
        this.kopOauth2ConfigFile = kopOauth2ConfigFile;
    }

    public void setKopPrometheusStatsLatencyRolloverSeconds(int kopPrometheusStatsLatencyRolloverSeconds) {
        this.kopPrometheusStatsLatencyRolloverSeconds = kopPrometheusStatsLatencyRolloverSeconds;
    }

    public void setKopEnableGroupLevelConsumerMetrics(boolean kopEnableGroupLevelConsumerMetrics) {
        this.kopEnableGroupLevelConsumerMetrics = kopEnableGroupLevelConsumerMetrics;
    }

    public void setKopAllowedNamespaces(Set<String> kopAllowedNamespaces) {
        this.kopAllowedNamespaces = kopAllowedNamespaces;
    }

    public void setKopSchemaRegistryEnable(boolean kopSchemaRegistryEnable) {
        this.kopSchemaRegistryEnable = kopSchemaRegistryEnable;
    }

    public void setKopSchemaRegistryTopicName(String kopSchemaRegistryTopicName) {
        this.kopSchemaRegistryTopicName = kopSchemaRegistryTopicName;
    }

    public void setKopSchemaRegistryPort(int kopSchemaRegistryPort) {
        this.kopSchemaRegistryPort = kopSchemaRegistryPort;
    }

    public void setKopMigrationEnable(boolean kopMigrationEnable) {
        this.kopMigrationEnable = kopMigrationEnable;
    }

    public void setKopMigrationServicePort(int kopMigrationServicePort) {
        this.kopMigrationServicePort = kopMigrationServicePort;
    }

    public void setKafkaCompressionType(String kafkaCompressionType) {
        this.kafkaCompressionType = kafkaCompressionType;
    }

    public void setSkipMessagesWithoutIndex(boolean skipMessagesWithoutIndex) {
        this.skipMessagesWithoutIndex = skipMessagesWithoutIndex;
    }
}

