/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.netty.channel.Channel;
import io.streamnative.pulsar.handlers.kop.KopBrokerLookupManager;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopicLookupService {
    private static final Logger log = LoggerFactory.getLogger(KafkaTopicLookupService.class);
    private final BrokerService brokerService;

    KafkaTopicLookupService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public CompletableFuture<Optional<PersistentTopic>> getTopic(String topicName, Channel channel) {
        CompletableFuture<Optional<PersistentTopic>> topicCompletableFuture = new CompletableFuture<Optional<PersistentTopic>>();
        this.brokerService.getTopicIfExists(topicName).whenComplete((t2, throwable) -> {
            TopicName topicNameObject = TopicName.get((String)topicName);
            if (throwable != null) {
                KopBrokerLookupManager.removeTopicManagerCache(topicName);
                if (topicNameObject.getPartitionIndex() == 0) {
                    log.warn("Get partition-0 error [{}].", (Object)throwable.getMessage());
                } else {
                    this.handleGetTopicException(topicName, topicCompletableFuture, (Throwable)throwable, channel);
                    return;
                }
            }
            if (t2 != null && t2.isPresent()) {
                topicCompletableFuture.complete(Optional.of((PersistentTopic)t2.get()));
                return;
            }
            if (topicNameObject.getPartitionIndex() == 0) {
                String nonPartitionedTopicName = topicNameObject.getPartitionedTopicName();
                if (log.isDebugEnabled()) {
                    log.debug("[{}]Try to get non-partitioned topic for name {}", (Object)channel, (Object)nonPartitionedTopicName);
                }
                this.brokerService.getTopicIfExists(nonPartitionedTopicName).whenComplete((nonPartitionedTopic, ex) -> {
                    if (ex != null) {
                        this.handleGetTopicException(nonPartitionedTopicName, topicCompletableFuture, (Throwable)ex, channel);
                        KopBrokerLookupManager.removeTopicManagerCache(nonPartitionedTopicName);
                        return;
                    }
                    if (nonPartitionedTopic.isPresent()) {
                        PersistentTopic persistentTopic = (PersistentTopic)nonPartitionedTopic.get();
                        topicCompletableFuture.complete(Optional.of(persistentTopic));
                    } else {
                        log.error("[{}]Get empty non-partitioned topic for name {}", (Object)channel, (Object)nonPartitionedTopicName);
                        KopBrokerLookupManager.removeTopicManagerCache(nonPartitionedTopicName);
                        topicCompletableFuture.complete(Optional.empty());
                    }
                });
                return;
            }
            log.error("[{}]Get empty topic for name {}", (Object)channel, (Object)topicName);
            KopBrokerLookupManager.removeTopicManagerCache(topicName);
            topicCompletableFuture.complete(Optional.empty());
        });
        return topicCompletableFuture;
    }

    private void handleGetTopicException(@NonNull String topicName, @NonNull CompletableFuture<Optional<PersistentTopic>> topicCompletableFuture, @NonNull Throwable ex, @NonNull Channel channel) {
        if (topicName == null) {
            throw new NullPointerException("topicName is marked non-null but is null");
        }
        if (topicCompletableFuture == null) {
            throw new NullPointerException("topicCompletableFuture is marked non-null but is null");
        }
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (ex instanceof BrokerServiceException.ServiceUnitNotReadyException) {
            log.warn("[{}] Failed to getTopic {}: {}", new Object[]{channel, topicName, ex.getMessage()});
            topicCompletableFuture.complete(Optional.empty());
        } else {
            log.error("[{}] Failed to getTopic {}. exception:", new Object[]{channel, topicName, ex});
            topicCompletableFuture.completeExceptionally(ex);
        }
    }
}

