/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.KopEventManager;
import io.streamnative.pulsar.handlers.kop.stats.StatsLogger;
import java.util.concurrent.BlockingQueue;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StatsDoc(name="kop_server", category="server", help="KOP event manager stats")
public class KopEventManagerStats {
    private static final Logger log = LoggerFactory.getLogger(KopEventManagerStats.class);
    private final BlockingQueue<KopEventManager.KopEventWrapper> eventQueue;
    private final StatsLogger statsLogger;

    public KopEventManagerStats(StatsLogger statsLogger, final BlockingQueue<KopEventManager.KopEventWrapper> eventQueue) {
        this.statsLogger = statsLogger;
        this.eventQueue = eventQueue;
        statsLogger.registerGauge("KOP_EVENT_QUEUE_SIZE", new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return eventQueue.size();
            }
        });
    }

    public BlockingQueue<KopEventManager.KopEventWrapper> getEventQueue() {
        return this.eventQueue;
    }

    public StatsLogger getStatsLogger() {
        return this.statsLogger;
    }
}

