/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.utils.CoreUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListPair<T> {
    private final Map<Boolean, List<T>> data;

    public <R> ListPair<R> map(Function<T, R> function) {
        return ListPair.of(CoreUtils.mapValue(this.data, list -> CoreUtils.listToList(list, function)));
    }

    public List<T> getSuccessfulList() {
        return Optional.ofNullable(this.data.get(true)).orElse(Collections.emptyList());
    }

    public List<T> getFailedList() {
        return Optional.ofNullable(this.data.get(false)).orElse(Collections.emptyList());
    }

    public static <T> ListPair<T> split(Stream<T> stream, Function<T, Boolean> function) {
        return ListPair.of(stream.collect(Collectors.groupingBy(function)));
    }

    public static <T> ListPair<T> of(Map<Boolean, List<T>> data) {
        return new ListPair<T>(data);
    }

    private ListPair(Map<Boolean, List<T>> data) {
        this.data = data != null ? data : Collections.emptyMap();
    }
}

