/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.AbstractPulsarClient;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupClient
extends AbstractPulsarClient {
    private static final Logger log = LoggerFactory.getLogger(LookupClient.class);

    public LookupClient(PulsarService pulsarService, KafkaServiceConfiguration kafkaConfig) {
        super(LookupClient.createPulsarClient(pulsarService, kafkaConfig, conf -> {}));
    }

    public CompletableFuture<InetSocketAddress> getBrokerAddress(TopicName topicName) {
        return this.getPulsarClient().getLookup().getBroker(topicName).thenApply(Pair::getLeft);
    }
}

