/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.netty.util.Recycler;
import io.streamnative.pulsar.handlers.kop.KafkaCommandDecoder;
import io.streamnative.pulsar.handlers.kop.KafkaRequestHandler;
import io.streamnative.pulsar.handlers.kop.KafkaTopicManager;
import io.streamnative.pulsar.handlers.kop.KafkaTopicManagerSharedState;
import io.streamnative.pulsar.handlers.kop.RequestStats;
import io.streamnative.pulsar.handlers.kop.coordinator.transaction.TransactionCoordinator;
import io.streamnative.pulsar.handlers.kop.utils.GroupIdUtils;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.pulsar.metadata.api.GetResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageFetchContext {
    private static final Logger log = LoggerFactory.getLogger(MessageFetchContext.class);
    private static final Recycler<MessageFetchContext> RECYCLER = new Recycler<MessageFetchContext>(){

        protected MessageFetchContext newObject(Recycler.Handle<MessageFetchContext> handle) {
            return new MessageFetchContext(handle);
        }
    };
    private final Recycler.Handle<MessageFetchContext> recyclerHandle;
    private volatile KafkaRequestHandler requestHandler;
    private volatile KafkaTopicManager topicManager;
    private volatile RequestStats statsLogger;
    private volatile TransactionCoordinator tc;
    private volatile String clientHost;
    private volatile String namespacePrefix;
    private volatile int maxReadEntriesNum;
    private volatile RequestHeader header;
    private volatile KafkaTopicManagerSharedState sharedState;
    private volatile ScheduledExecutorService decodeExecutor;

    public static MessageFetchContext get(KafkaRequestHandler requestHandler, TransactionCoordinator tc, int maxReadEntriesNum, String namespacePrefix, KafkaTopicManagerSharedState sharedState, ScheduledExecutorService decodeExecutor, KafkaCommandDecoder.KafkaHeaderAndRequest kafkaHeaderAndRequest) {
        MessageFetchContext context = (MessageFetchContext)RECYCLER.get();
        context.requestHandler = requestHandler;
        context.sharedState = sharedState;
        context.decodeExecutor = decodeExecutor;
        context.topicManager = requestHandler.getTopicManager();
        context.statsLogger = requestHandler.requestStats;
        context.tc = tc;
        context.clientHost = kafkaHeaderAndRequest.getClientHost();
        context.header = kafkaHeaderAndRequest.getHeader();
        context.namespacePrefix = namespacePrefix;
        context.maxReadEntriesNum = maxReadEntriesNum;
        return context;
    }

    private MessageFetchContext(Recycler.Handle<MessageFetchContext> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public CompletableFuture<String> getCurrentConnectedGroupNameAsync() {
        return this.requestHandler.getCurrentConnectedGroup().computeIfAbsent(this.clientHost, clientHost -> {
            CompletableFuture storeGroupIdFuture = new CompletableFuture();
            String groupIdPath = GroupIdUtils.groupIdPathFormat(clientHost, this.header.clientId());
            ((CompletableFuture)this.requestHandler.getMetadataStore().get(this.requestHandler.getGroupIdStoredPath() + groupIdPath).thenAccept(getResultOpt -> {
                if (getResultOpt.isPresent()) {
                    GetResult getResult = (GetResult)getResultOpt.get();
                    storeGroupIdFuture.complete(new String(getResult.getValue() == null ? new byte[]{} : getResult.getValue(), StandardCharsets.UTF_8));
                } else {
                    storeGroupIdFuture.complete("");
                }
            })).exceptionally(ex -> {
                storeGroupIdFuture.completeExceptionally((Throwable)ex);
                return null;
            });
            return storeGroupIdFuture;
        });
    }

    public void recycle() {
        this.requestHandler = null;
        this.sharedState = null;
        this.decodeExecutor = null;
        this.topicManager = null;
        this.statsLogger = null;
        this.tc = null;
        this.clientHost = null;
        this.header = null;
        this.maxReadEntriesNum = -1;
        this.namespacePrefix = null;
        this.recyclerHandle.recycle((Object)this);
    }

    public Recycler.Handle<MessageFetchContext> getRecyclerHandle() {
        return this.recyclerHandle;
    }

    public KafkaRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public KafkaTopicManager getTopicManager() {
        return this.topicManager;
    }

    public RequestStats getStatsLogger() {
        return this.statsLogger;
    }

    public TransactionCoordinator getTc() {
        return this.tc;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public int getMaxReadEntriesNum() {
        return this.maxReadEntriesNum;
    }

    public RequestHeader getHeader() {
        return this.header;
    }

    public KafkaTopicManagerSharedState getSharedState() {
        return this.sharedState;
    }

    public ScheduledExecutorService getDecodeExecutor() {
        return this.decodeExecutor;
    }
}

