/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsar.handlers.kop.RequestStats;
import io.streamnative.pulsar.handlers.kop.TopicThrowablePair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;

public class PendingTopicFutures {
    private final RequestStats requestStats;
    private final long enqueueTimestamp;
    private int count = 0;
    private CompletableFuture<TopicThrowablePair> currentTopicFuture;

    public PendingTopicFutures(RequestStats requestStats) {
        this.requestStats = requestStats;
        this.enqueueTimestamp = MathUtils.nowInNano();
    }

    private void registerQueueLatency(boolean success) {
        if (this.requestStats != null) {
            if (success) {
                this.requestStats.getMessageQueuedLatencyStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueTimestamp), TimeUnit.NANOSECONDS);
            } else {
                this.requestStats.getMessageQueuedLatencyStats().registerFailedEvent(MathUtils.elapsedNanos((long)this.enqueueTimestamp), TimeUnit.NANOSECONDS);
            }
        }
    }

    private synchronized void decrementCount() {
        --this.count;
    }

    public synchronized void addListener(CompletableFuture<Optional<PersistentTopic>> topicFuture, @NonNull Consumer<Optional<PersistentTopic>> persistentTopicConsumer, @NonNull Consumer<Throwable> exceptionConsumer) {
        if (persistentTopicConsumer == null) {
            throw new NullPointerException("persistentTopicConsumer is marked non-null but is null");
        }
        if (exceptionConsumer == null) {
            throw new NullPointerException("exceptionConsumer is marked non-null but is null");
        }
        if (this.count == 0) {
            this.count = 1;
            this.currentTopicFuture = ((CompletableFuture)topicFuture.thenApply(persistentTopic -> {
                this.registerQueueLatency(true);
                persistentTopicConsumer.accept((Optional<PersistentTopic>)persistentTopic);
                this.decrementCount();
                return TopicThrowablePair.withTopic(persistentTopic);
            })).exceptionally(e -> {
                this.registerQueueLatency(false);
                exceptionConsumer.accept(e.getCause());
                this.decrementCount();
                return TopicThrowablePair.withThrowable(e.getCause());
            });
        } else {
            ++this.count;
            this.currentTopicFuture = ((CompletableFuture)this.currentTopicFuture.thenApply(topicThrowablePair -> {
                if (topicThrowablePair.getThrowable() == null) {
                    this.registerQueueLatency(true);
                    persistentTopicConsumer.accept(topicThrowablePair.getPersistentTopicOpt());
                } else {
                    this.registerQueueLatency(false);
                    exceptionConsumer.accept(topicThrowablePair.getThrowable());
                }
                this.decrementCount();
                return topicThrowablePair;
            })).exceptionally(e -> {
                this.registerQueueLatency(false);
                exceptionConsumer.accept(e.getCause());
                this.decrementCount();
                return TopicThrowablePair.withThrowable(e.getCause());
            });
        }
    }

    @VisibleForTesting
    public synchronized int waitAndGetSize() throws ExecutionException, InterruptedException {
        this.currentTopicFuture.get();
        return this.count;
    }

    @VisibleForTesting
    public synchronized int size() {
        return this.count;
    }
}

