/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsar.handlers.kop.stats.NullStatsLogger;
import io.streamnative.pulsar.handlers.kop.stats.StatsLogger;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StatsDoc(name="kop_server", category="server", help="KOP request stats")
public class RequestStats {
    private static final Logger log = LoggerFactory.getLogger(RequestStats.class);
    public static final AtomicInteger REQUEST_QUEUE_SIZE_INSTANCE = new AtomicInteger(0);
    public static final AtomicInteger BATCH_COUNT_PER_MEMORY_RECORDS_INSTANCE = new AtomicInteger(0);
    public static final AtomicInteger ALIVE_CHANNEL_COUNT_INSTANCE = new AtomicInteger(0);
    public static final AtomicInteger ACTIVE_CHANNEL_COUNT_INSTANCE = new AtomicInteger(0);
    public static final RequestStats NULL_INSTANCE = new RequestStats(NullStatsLogger.INSTANCE);
    private final StatsLogger statsLogger;
    @StatsDoc(name="WAITING_FETCHES_TRIGGERED", help="number of pending fetches that woke up due to some data produced")
    private final Counter waitingFetchesTriggered;
    @StatsDoc(name="REQUEST_PARSE_LATENCY", help="parse ByteBuf to request latency")
    private final OpStatsLogger requestParseLatencyStats;
    @StatsDoc(name="RESPONSE_BLOCKED_TIMES", help="response blocked times")
    private final Counter responseBlockedTimes;
    @StatsDoc(name="RESPONSE_BLOCKED_LATENCY", help="response blocked latency")
    private final OpStatsLogger responseBlockedLatency;
    @StatsDoc(name="PENDING_TOPIC_LATENCY", help="pending topic latency stats of Kop")
    private final OpStatsLogger pendingTopicLatencyStats;
    @StatsDoc(name="PRODUCE_ENCODE", help="produce encode stats of Kop")
    private final OpStatsLogger produceEncodeStats;
    @StatsDoc(name="MESSAGE_PUBLISH", help="message publish stats from kop to pulsar broker")
    private final OpStatsLogger messagePublishStats;
    @StatsDoc(name="MESSAGE_QUEUED_LATENCY", help="message queued stats from kop to pulsar broker")
    private final OpStatsLogger messageQueuedLatencyStats;
    @StatsDoc(name="PREPARE_METADATA", help="stats of preparing metadata in fetch request")
    private final OpStatsLogger prepareMetadataStats;
    @StatsDoc(name="MESSAGE_READ", help="stats of performing a single cursor's async-read within fetch request")
    private final OpStatsLogger messageReadStats;
    @StatsDoc(name="FETCH_DECODE", help="stats of decoding entries in fetch request")
    private final OpStatsLogger fetchDecodeStats;
    @StatsDoc(name="NETWORK_TOTAL_BYTES_IN", help="total bytes received")
    private final Counter networkTotalBytesIn;
    @StatsDoc(name="NETWORK_TOTAL_BYTES_OUT", help="total bytes sent out")
    private final Counter networkTotalBytesOut;
    private final Map<ApiKeys, StatsLogger> apiKeysToStatsLogger = new ConcurrentHashMap<ApiKeys, StatsLogger>();
    private final Map<TopicPartition, StatsLogger> cachedLoggersForTopicPartitions = new ConcurrentHashMap<TopicPartition, StatsLogger>();
    private final Map<Pair<TopicPartition, String>, StatsLogger> cachedLoggersForTopicPartitionsAndGroups = new ConcurrentHashMap<Pair<TopicPartition, String>, StatsLogger>();
    private final Map<String, RequestStats> cachedRequestStatsForTenants = new ConcurrentHashMap<String, RequestStats>();

    public RequestStats(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        this.requestParseLatencyStats = statsLogger.getOpStatsLogger("REQUEST_PARSE_LATENCY");
        this.responseBlockedLatency = statsLogger.getOpStatsLogger("RESPONSE_BLOCKED_LATENCY");
        this.responseBlockedTimes = statsLogger.getCounter("RESPONSE_BLOCKED_TIMES");
        this.pendingTopicLatencyStats = statsLogger.getOpStatsLogger("PENDING_TOPIC_LATENCY");
        this.produceEncodeStats = statsLogger.getOpStatsLogger("PRODUCE_ENCODE");
        this.messagePublishStats = statsLogger.getOpStatsLogger("MESSAGE_PUBLISH");
        this.messageQueuedLatencyStats = statsLogger.getOpStatsLogger("MESSAGE_QUEUED_LATENCY");
        this.prepareMetadataStats = statsLogger.getOpStatsLogger("PREPARE_METADATA");
        this.messageReadStats = statsLogger.getOpStatsLogger("MESSAGE_READ");
        this.fetchDecodeStats = statsLogger.getOpStatsLogger("FETCH_DECODE");
        this.waitingFetchesTriggered = statsLogger.getCounter("WAITING_FETCHES_TRIGGERED");
        this.networkTotalBytesIn = statsLogger.getCounter("NETWORK_TOTAL_BYTES_IN");
        this.networkTotalBytesOut = statsLogger.getCounter("NETWORK_TOTAL_BYTES_OUT");
        statsLogger.registerGauge("REQUEST_QUEUE_SIZE", new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return REQUEST_QUEUE_SIZE_INSTANCE;
            }
        });
        statsLogger.registerGauge("BATCH_COUNT_PER_MEMORYRECORDS", new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return BATCH_COUNT_PER_MEMORY_RECORDS_INSTANCE;
            }
        });
        statsLogger.registerGauge("ALIVE_CHANNEL_COUNT", new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return ALIVE_CHANNEL_COUNT_INSTANCE;
            }
        });
        statsLogger.registerGauge("ACTIVE_CHANNEL_COUNT", new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return ACTIVE_CHANNEL_COUNT_INSTANCE;
            }
        });
    }

    public StatsLogger getStatsLoggerForTopicPartition(TopicPartition topicPartition) {
        return this.cachedLoggersForTopicPartitions.computeIfAbsent(topicPartition, __ -> this.statsLogger.scopeLabel("topic", topicPartition.topic()).scopeLabel("partition", String.valueOf(topicPartition.partition())));
    }

    public StatsLogger getStatsLoggerForTopicPartitionAndGroup(TopicPartition topicPartition, String groupId) {
        return this.cachedLoggersForTopicPartitionsAndGroups.computeIfAbsent((Pair<TopicPartition, String>)Pair.of((Object)topicPartition, (Object)groupId), __ -> this.getStatsLoggerForTopicPartition(topicPartition).scopeLabel("group", groupId));
    }

    public OpStatsLogger getRequestStatsLogger(ApiKeys apiKey, String statsName) {
        return this.apiKeysToStatsLogger.computeIfAbsent(apiKey, __ -> this.statsLogger.scopeLabel("request", apiKey.name)).getOpStatsLogger(statsName);
    }

    @VisibleForTesting
    public Set<ApiKeys> getApiKeysSet() {
        return new TreeSet<ApiKeys>(this.apiKeysToStatsLogger.keySet());
    }

    public RequestStats forTenant(String tenant) {
        return this.cachedRequestStatsForTenants.computeIfAbsent(tenant, __ -> new RequestStats(this.statsLogger.scopeLabel("tenant", tenant)));
    }

    public StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    public Counter getWaitingFetchesTriggered() {
        return this.waitingFetchesTriggered;
    }

    public OpStatsLogger getRequestParseLatencyStats() {
        return this.requestParseLatencyStats;
    }

    public Counter getResponseBlockedTimes() {
        return this.responseBlockedTimes;
    }

    public OpStatsLogger getResponseBlockedLatency() {
        return this.responseBlockedLatency;
    }

    public OpStatsLogger getPendingTopicLatencyStats() {
        return this.pendingTopicLatencyStats;
    }

    public OpStatsLogger getProduceEncodeStats() {
        return this.produceEncodeStats;
    }

    public OpStatsLogger getMessagePublishStats() {
        return this.messagePublishStats;
    }

    public OpStatsLogger getMessageQueuedLatencyStats() {
        return this.messageQueuedLatencyStats;
    }

    public OpStatsLogger getPrepareMetadataStats() {
        return this.prepareMetadataStats;
    }

    public OpStatsLogger getMessageReadStats() {
        return this.messageReadStats;
    }

    public OpStatsLogger getFetchDecodeStats() {
        return this.fetchDecodeStats;
    }

    public Counter getNetworkTotalBytesIn() {
        return this.networkTotalBytesIn;
    }

    public Counter getNetworkTotalBytesOut() {
        return this.networkTotalBytesOut;
    }

    public Map<ApiKeys, StatsLogger> getApiKeysToStatsLogger() {
        return this.apiKeysToStatsLogger;
    }

    public Map<TopicPartition, StatsLogger> getCachedLoggersForTopicPartitions() {
        return this.cachedLoggersForTopicPartitions;
    }

    public Map<Pair<TopicPartition, String>, StatsLogger> getCachedLoggersForTopicPartitionsAndGroups() {
        return this.cachedLoggersForTopicPartitionsAndGroups;
    }

    public Map<String, RequestStats> getCachedRequestStatsForTenants() {
        return this.cachedRequestStatsForTenants;
    }
}

