/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.AbstractPulsarClient;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import java.nio.ByteBuffer;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.Schema;

public class SystemTopicClient
extends AbstractPulsarClient {
    private final int maxPendingMessages;

    public SystemTopicClient(PulsarService pulsarService, KafkaServiceConfiguration kafkaConfig) {
        super(SystemTopicClient.createPulsarClient(pulsarService, kafkaConfig, conf -> conf.setStatsIntervalSeconds(0L)));
        this.maxPendingMessages = kafkaConfig.getKafkaMetaMaxPendingMessages();
    }

    public ProducerBuilder<ByteBuffer> newProducerBuilder() {
        return this.getPulsarClient().newProducer(Schema.BYTEBUFFER).maxPendingMessages(this.maxPendingMessages).blockIfQueueFull(true);
    }

    public ReaderBuilder<ByteBuffer> newReaderBuilder() {
        return this.getPulsarClient().newReader(Schema.BYTEBUFFER).startMessageId(MessageId.earliest);
    }
}

