/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.utils.CoreUtils;
import io.streamnative.pulsar.handlers.kop.utils.KopTopic;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.pulsar.common.naming.TopicName;

public class TopicAndMetadata {
    public static final int INVALID_PARTITIONS = -2;
    public static final int AUTHORIZATION_FAILURE = -1;
    public static final int NON_PARTITIONED_NUMBER = 0;
    private final String topic;
    private final int numPartitions;

    public boolean isPartitionedTopic() {
        return this.numPartitions > 0;
    }

    public boolean hasNoError() {
        return this.numPartitions >= 0;
    }

    public Errors error() {
        if (this.hasNoError()) {
            return Errors.NONE;
        }
        if (this.numPartitions == -1) {
            return Errors.TOPIC_AUTHORIZATION_FAILED;
        }
        return Errors.UNKNOWN_TOPIC_OR_PARTITION;
    }

    public CompletableFuture<MetadataResponse.TopicMetadata> lookupAsync(Function<TopicName, CompletableFuture<MetadataResponse.PartitionMetadata>> lookupFunction, Function<String, String> getOriginalTopic, String metadataNamespace) {
        return CoreUtils.waitForAll(this.stream().map(TopicName::get).map(lookupFunction).collect(Collectors.toList()), partitionMetadataList -> new MetadataResponse.TopicMetadata(this.error(), (String)getOriginalTopic.apply(this.topic), KopTopic.isInternalTopic(this.topic, metadataNamespace), partitionMetadataList));
    }

    public Stream<String> stream() {
        if (this.numPartitions > 0) {
            return IntStream.range(0, this.numPartitions).mapToObj(i -> this.topic + "-partition-" + i);
        }
        return Stream.of(this.topic);
    }

    public MetadataResponse.TopicMetadata toTopicMetadata(Function<String, String> getOriginalTopic, String metadataNamespace) {
        return new MetadataResponse.TopicMetadata(this.error(), getOriginalTopic.apply(this.topic), KopTopic.isInternalTopic(this.topic, metadataNamespace), Collections.emptyList());
    }

    public TopicAndMetadata(String topic, int numPartitions) {
        this.topic = topic;
        this.numPartitions = numPartitions;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }
}

