/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.group;

import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupCoordinator;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupMetadata;
import io.streamnative.pulsar.handlers.kop.coordinator.group.MemberMetadata;
import io.streamnative.pulsar.handlers.kop.utils.delayed.DelayedOperation;
import java.util.Optional;

class DelayedHeartbeat
extends DelayedOperation {
    private final GroupCoordinator coordinator;
    private final GroupMetadata group;
    private final MemberMetadata member;
    private final long heartbeatDeadline;

    DelayedHeartbeat(GroupCoordinator coordinator, GroupMetadata group, MemberMetadata member, long heartbeatDeadline, long sessionTimeout) {
        super(sessionTimeout, Optional.of(group.lock()));
        this.coordinator = coordinator;
        this.group = group;
        this.member = member;
        this.heartbeatDeadline = heartbeatDeadline;
    }

    @Override
    public void onExpiration() {
        this.coordinator.onExpireHeartbeat(this.group, this.member, this.heartbeatDeadline);
    }

    @Override
    public void onComplete() {
        this.coordinator.onCompleteHeartbeat();
    }

    @Override
    public boolean tryComplete() {
        return this.coordinator.tryCompleteHeartbeat(this.group, this.member, this.heartbeatDeadline, this::forceComplete);
    }
}

