/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupState;
import io.streamnative.pulsar.handlers.kop.coordinator.group.MemberMetadata;
import io.streamnative.pulsar.handlers.kop.exceptions.KoPTopicException;
import io.streamnative.pulsar.handlers.kop.offset.OffsetAndMetadata;
import io.streamnative.pulsar.handlers.kop.utils.CoreUtils;
import io.streamnative.pulsar.handlers.kop.utils.KopTopic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.pulsar.common.schema.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class GroupMetadata {
    private static final Logger log = LoggerFactory.getLogger(GroupMetadata.class);
    private static final Map<GroupState, Set<GroupState>> validPreviousStates = new HashMap<GroupState, Set<GroupState>>();
    private final String groupId;
    private final ReentrantLock lock = new ReentrantLock();
    private GroupState state;
    private Optional<String> protocolType = Optional.empty();
    private int generationId = 0;
    private Optional<String> leaderId = Optional.empty();
    private Optional<String> protocol = Optional.empty();
    private boolean newMemberAdded = false;
    private final Map<String, MemberMetadata> members = Collections.synchronizedMap(new HashMap());
    private final Map<TopicPartition, CommitRecordMetadataAndOffset> offsets = Collections.synchronizedMap(new HashMap());
    private final Map<TopicPartition, OffsetAndMetadata> pendingOffsetCommits = Collections.synchronizedMap(new HashMap());
    private final Map<Long, Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits = Collections.synchronizedMap(new HashMap());
    private boolean receivedTransactionalOffsetCommits = false;
    private boolean receivedConsumerOffsetCommits = false;

    public static GroupMetadata loadGroup(String groupId, GroupState initialState, int generationId, String protocolType, String protocol, String leaderId, Iterable<MemberMetadata> members) {
        GroupMetadata metadata = new GroupMetadata(groupId, initialState).generationId(generationId).protocolType(StringUtils.isEmpty((CharSequence)protocolType) ? Optional.empty() : Optional.of(protocolType)).protocol(Optional.ofNullable(protocol)).leaderId(Optional.ofNullable(leaderId));
        members.forEach(metadata::add);
        return metadata;
    }

    GroupMetadata(String groupId, GroupState initialState) {
        this.groupId = groupId;
        this.state = initialState;
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public void newMemberAdded(boolean newMemberAdded) {
        this.newMemberAdded = newMemberAdded;
    }

    public <T> T inLock(Supplier<T> supplier) {
        return CoreUtils.inLock(this.lock, supplier);
    }

    public Optional<String> protocolType() {
        return this.protocolType;
    }

    public GroupState currentState() {
        return this.state;
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public Set<String> allMembers() {
        return this.members.keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return new ArrayList<MemberMetadata>(this.members.values());
    }

    public int rebalanceTimeoutMs() {
        if (this.members.isEmpty()) {
            return 0;
        }
        return this.members.values().stream().mapToInt(MemberMetadata::rebalanceTimeoutMs).max().getAsInt();
    }

    public boolean is(GroupState groupState) {
        return this.state == groupState;
    }

    public boolean not(GroupState groupState) {
        return this.state != groupState;
    }

    public boolean has(String memberId) {
        return this.members.containsKey(memberId);
    }

    public MemberMetadata get(String memberId) {
        return this.members.get(memberId);
    }

    public boolean isLeader(String memberId) {
        return Objects.equals(this.leaderId.orElse(null), memberId);
    }

    public String leaderOrNull() {
        return this.leaderId.orElse(null);
    }

    public String protocolOrNull() {
        return this.protocol.orElse(null);
    }

    public String protocolTypeOrNull() {
        return this.protocolType.orElse(null);
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return this.members.values().stream().filter(e -> e.awaitingJoinCallback() == null).collect(Collectors.toList());
    }

    private Set<String> candidateProtocols() {
        return this.members.values().stream().map(MemberMetadata::protocols).reduce((p1, p2) -> new HashSet(Sets.intersection((Set)p1, (Set)p2))).orElse(Collections.emptySet());
    }

    public boolean supportsProtocols(Set<String> memberProtocols) {
        return this.members.isEmpty() || !Sets.intersection(memberProtocols, this.candidateProtocols()).isEmpty();
    }

    public void initNextGeneration() {
        Preconditions.checkArgument((boolean)this.notYetRejoinedMembers().isEmpty());
        if (!this.members.isEmpty()) {
            ++this.generationId;
            this.protocol = Optional.ofNullable(this.selectProtocol());
            this.transitionTo(GroupState.CompletingRebalance);
        } else {
            ++this.generationId;
            this.protocol = Optional.empty();
            this.transitionTo(GroupState.Empty);
        }
    }

    public void add(MemberMetadata member) {
        if (this.members.isEmpty()) {
            this.protocolType = Optional.of(member.protocolType());
        }
        Preconditions.checkArgument((boolean)this.groupId.equals(member.groupId()));
        Preconditions.checkArgument((boolean)Objects.equals(this.protocolType.orElse(null), member.protocolType()));
        Preconditions.checkArgument((boolean)this.supportsProtocols(member.protocols()));
        if (!this.leaderId.isPresent()) {
            this.leaderId = Optional.of(member.memberId());
        }
        this.members.put(member.memberId(), member);
    }

    public void remove(String memberId) {
        this.members.remove(memberId);
        if (this.isLeader(memberId)) {
            this.leaderId = this.members.isEmpty() ? Optional.empty() : this.members.keySet().stream().findFirst();
        }
    }

    public boolean canRebalance() {
        return validPreviousStates.get((Object)GroupState.PreparingRebalance).contains((Object)this.state);
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state = groupState;
    }

    private void assertValidTransition(GroupState targetState) {
        if (!validPreviousStates.get((Object)targetState).contains((Object)this.state)) {
            throw new IllegalStateException(String.format("Group %s should be in the %s states before moving to %s state. Instead it is in %s state", new Object[]{this.groupId, StringUtils.join((Iterable)validPreviousStates.get((Object)targetState), (String)","), targetState, this.state}));
        }
    }

    public String selectProtocol() {
        Preconditions.checkState((!this.members.isEmpty() ? 1 : 0) != 0, (Object)"Cannot select protocol for empty group");
        Set<String> candidates = this.candidateProtocols();
        return this.members.values().stream().map(m -> m.vote(candidates)).collect(Collectors.groupingBy(protocol -> protocol)).entrySet().stream().max(Comparator.comparingInt(o -> ((List)o.getValue()).size())).map(Map.Entry::getKey).orElse(null);
    }

    public Map<String, byte[]> currentMemberMetadata() {
        if (this.is(GroupState.Dead) || this.is(GroupState.PreparingRebalance)) {
            throw new IllegalStateException("Cannot obtain member metadata for group in state " + this.state);
        }
        return this.members.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MemberMetadata)e.getValue()).metadata(this.protocol.get())));
    }

    public GroupSummary summary() {
        if (this.is(GroupState.Stable)) {
            String protocol = this.protocolOrNull();
            Preconditions.checkState((protocol != null ? 1 : 0) != 0, (Object)"Invalid null group protocol for stable group");
            List<MemberMetadata.MemberSummary> summaries = this.members.values().stream().map(member -> member.summary(protocol)).collect(Collectors.toList());
            return new GroupSummary(this.state.toString(), this.protocolType.orElse(""), protocol, summaries);
        }
        List<MemberMetadata.MemberSummary> summaries = this.members.values().stream().map(MemberMetadata::summaryNoMetadata).collect(Collectors.toList());
        return new GroupSummary(this.state.toString(), this.protocolType.orElse(""), "", summaries);
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId, this.protocolType.orElse(""));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, Map<Long, Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.offsets.putAll(offsets);
        this.pendingTransactionalOffsetCommits.putAll(pendingTxnOffsets);
    }

    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        OffsetAndMetadata stagedOffset;
        if (this.pendingOffsetCommits.containsKey(topicPartition)) {
            if (!offsetWithCommitRecordMetadata.appendedPosition.isPresent()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            if (!this.offsets.containsKey(topicPartition) || this.offsets.get(topicPartition).olderThan(offsetWithCommitRecordMetadata)) {
                this.offsets.put(topicPartition, offsetWithCommitRecordMetadata);
            }
        }
        if (offsetWithCommitRecordMetadata.offsetAndMetadata.equals(stagedOffset = this.pendingOffsetCommits.get(topicPartition))) {
            this.pendingOffsetCommits.remove(topicPartition);
        }
    }

    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset) {
        OffsetAndMetadata pendingOffset = this.pendingOffsetCommits.get(topicPartition);
        if (offset.equals(pendingOffset)) {
            this.pendingOffsetCommits.remove(topicPartition);
        }
    }

    public void prepareOffsetCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits = true;
        this.pendingOffsetCommits.putAll(offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, Map<TopicPartition, OffsetAndMetadata> offsets) {
        if (log.isTraceEnabled()) {
            log.trace("TxnOffsetCommit for producer {} and group {} with offsets {} is pending", new Object[]{producerId, this.groupId, offsets});
        }
        this.receivedTransactionalOffsetCommits = true;
        Map producerOffsets = this.pendingTransactionalOffsetCommits.computeIfAbsent(producerId, pid -> new HashMap());
        offsets.forEach((tp, offsetsAndMetadata) -> producerOffsets.put(tp, new CommitRecordMetadataAndOffset(Optional.empty(), (OffsetAndMetadata)offsetsAndMetadata)));
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits || !this.receivedTransactionalOffsetCommits;
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Map<TopicPartition, CommitRecordMetadataAndOffset> pendingOffsets = this.pendingTransactionalOffsetCommits.get(producerId);
        if (null != pendingOffsets) {
            CommitRecordMetadataAndOffset pendingOffsetCommit = pendingOffsets.remove(topicPartition);
            if (log.isTraceEnabled()) {
                log.trace("TxnOffsetCommit for producer {} and group {} with offsets {} failed to be appended to the log", new Object[]{producerId, this.groupId, pendingOffsetCommit});
            }
            if (pendingOffsets.isEmpty()) {
                this.pendingTransactionalOffsetCommits.remove(producerId);
            }
        }
    }

    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        Map<TopicPartition, CommitRecordMetadataAndOffset> pendingOffsets = this.pendingTransactionalOffsetCommits.get(producerId);
        if (null != pendingOffsets && pendingOffsets.containsKey(topicPartition) && pendingOffsets.get(topicPartition).offsetAndMetadata().equals(commitRecordMetadataAndOffset.offsetAndMetadata)) {
            pendingOffsets.put(topicPartition, commitRecordMetadataAndOffset);
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Map<TopicPartition, CommitRecordMetadataAndOffset> pendingOffsets = this.pendingTransactionalOffsetCommits.remove(producerId);
        if (isCommit) {
            if (null != pendingOffsets) {
                pendingOffsets.forEach((topicPartition, commitRecordMetadataAndOffset) -> {
                    if (!commitRecordMetadataAndOffset.appendedPosition.isPresent()) {
                        throw new IllegalStateException(String.format("Trying to complete a transactional offset commit for producerId %s and groupId %s even though the offset commit record itself hasn't been appended to the log.", producerId, this.groupId));
                    }
                    CommitRecordMetadataAndOffset currentOffsetOpt = this.offsets.get(topicPartition);
                    if (currentOffsetOpt == null || currentOffsetOpt.olderThan((CommitRecordMetadataAndOffset)commitRecordMetadataAndOffset)) {
                        if (log.isTraceEnabled()) {
                            log.trace("TxnOffsetCommit for producer {} and group {} with offset {} committed and loaded into the cache.", new Object[]{producerId, this.groupId, commitRecordMetadataAndOffset});
                        }
                        this.offsets.put((TopicPartition)topicPartition, (CommitRecordMetadataAndOffset)commitRecordMetadataAndOffset);
                    } else if (log.isTraceEnabled()) {
                        log.trace("TxnOffsetCommit for producer {} and group {} with offset {} committed, but not loaded since its offset is older than current offset {}.", new Object[]{producerId, this.groupId, commitRecordMetadataAndOffset, currentOffsetOpt});
                    }
                });
            }
        } else if (log.isTraceEnabled()) {
            log.trace("TxnOffsetCommit for producer {} and group {} with offsets {} aborted", new Object[]{producerId, this.groupId, pendingOffsets});
        }
    }

    public Set<Long> activeProducers() {
        return this.pendingTransactionalOffsetCommits.keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.pendingTransactionalOffsetCommits.containsKey(producerId);
    }

    public Map<TopicPartition, OffsetAndMetadata> removeAllOffsets() {
        return this.removeOffsets(new HashSet<TopicPartition>(this.offsets.keySet()).stream());
    }

    public Map<TopicPartition, OffsetAndMetadata> removeOffsets(Stream<TopicPartition> topicPartitions) {
        return topicPartitions.map(topicPartition -> {
            this.pendingOffsetCommits.remove(topicPartition);
            this.pendingTransactionalOffsetCommits.forEach((pid, pendingOffsets) -> pendingOffsets.remove(topicPartition));
            CommitRecordMetadataAndOffset removedOffset = this.offsets.remove(topicPartition);
            if (removedOffset == null) {
                return new KeyValue(topicPartition, (Object)OffsetAndMetadata.apply(0L));
            }
            return new KeyValue(topicPartition, (Object)removedOffset.offsetAndMetadata());
        }).collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
    }

    public List<TopicPartition> collectPartitionsWithTopics(Set<String> topics) {
        ArrayList topicPartitions = Lists.newArrayList();
        topicPartitions.addAll(this.pendingOffsetCommits.keySet().stream().filter(topicPartition -> topics.contains(topicPartition.topic())).collect(Collectors.toList()));
        this.pendingTransactionalOffsetCommits.values().stream().map(Map::keySet).collect(Collectors.toList()).forEach(partitionSet -> topicPartitions.addAll(partitionSet.stream().filter(topicPartition -> topics.contains(topicPartition.topic())).collect(Collectors.toList())));
        topicPartitions.addAll(this.offsets.keySet().stream().filter(topicPartition -> topics.contains(topicPartition.topic())).collect(Collectors.toList()));
        return topicPartitions;
    }

    public Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long startMs) {
        Map<TopicPartition, OffsetAndMetadata> expiredOffsets = this.offsets.entrySet().stream().filter(e -> ((CommitRecordMetadataAndOffset)e.getValue()).offsetAndMetadata().expireTimestamp() < startMs && !this.pendingOffsetCommits.containsKey(e.getKey())).map(e -> new KeyValue((Object)((TopicPartition)e.getKey()), (Object)((CommitRecordMetadataAndOffset)e.getValue()).offsetAndMetadata())).collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
        expiredOffsets.keySet().forEach(this.offsets::remove);
        return expiredOffsets;
    }

    public Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return this.offsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((CommitRecordMetadataAndOffset)e.getValue()).offsetAndMetadata()));
    }

    public Optional<OffsetAndMetadata> offset(TopicPartition topicPartition, String namespacePrefix) {
        return Optional.ofNullable(this.offsets.computeIfAbsent(topicPartition, tp -> {
            try {
                return this.offsets.get(new TopicPartition(new KopTopic(tp.topic(), namespacePrefix).getFullName(), tp.partition()));
            }
            catch (KoPTopicException e) {
                log.warn("Invalid topic name: {}", (Object)tp.topic(), (Object)e);
                return null;
            }
        })).map(e -> e.offsetAndMetadata);
    }

    @VisibleForTesting
    Optional<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return Optional.ofNullable(this.offsets.get(topicPartition));
    }

    public int numOffsets() {
        return this.offsets.size();
    }

    @VisibleForTesting
    int numPendingOffsetCommits() {
        return this.pendingOffsetCommits.size();
    }

    public boolean hasOffsets() {
        return !this.offsets.isEmpty() || !this.pendingOffsetCommits.isEmpty() || !this.pendingTransactionalOffsetCommits.isEmpty();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"GroupMetadata").add("groupId", (Object)this.groupId).add("generation", this.generationId).add("protocolType", this.protocolType).add("state", (Object)this.state).add("members", this.members);
        return helper.toString();
    }

    public GroupMetadata state(GroupState state) {
        this.state = state;
        return this;
    }

    public GroupMetadata protocolType(Optional<String> protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public GroupMetadata generationId(int generationId) {
        this.generationId = generationId;
        return this;
    }

    public GroupMetadata leaderId(Optional<String> leaderId) {
        this.leaderId = leaderId;
        return this;
    }

    public GroupMetadata protocol(Optional<String> protocol) {
        this.protocol = protocol;
        return this;
    }

    public GroupMetadata receivedTransactionalOffsetCommits(boolean receivedTransactionalOffsetCommits) {
        this.receivedTransactionalOffsetCommits = receivedTransactionalOffsetCommits;
        return this;
    }

    public GroupMetadata receivedConsumerOffsetCommits(boolean receivedConsumerOffsetCommits) {
        this.receivedConsumerOffsetCommits = receivedConsumerOffsetCommits;
        return this;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    static {
        validPreviousStates.put(GroupState.Dead, Sets.newHashSet((Object[])new GroupState[]{GroupState.Stable, GroupState.PreparingRebalance, GroupState.CompletingRebalance, GroupState.Empty, GroupState.Dead}));
        validPreviousStates.put(GroupState.CompletingRebalance, Sets.newHashSet((Object[])new GroupState[]{GroupState.PreparingRebalance}));
        validPreviousStates.put(GroupState.Stable, Sets.newHashSet((Object[])new GroupState[]{GroupState.CompletingRebalance}));
        validPreviousStates.put(GroupState.PreparingRebalance, Sets.newHashSet((Object[])new GroupState[]{GroupState.Stable, GroupState.CompletingRebalance, GroupState.Empty}));
        validPreviousStates.put(GroupState.Empty, Sets.newHashSet((Object[])new GroupState[]{GroupState.PreparingRebalance}));
    }

    public static class GroupSummary {
        private final String state;
        private final String protocolType;
        private final String protocol;
        private final List<MemberMetadata.MemberSummary> members;

        public GroupSummary(String state, String protocolType, String protocol, List<MemberMetadata.MemberSummary> members) {
            this.state = state;
            this.protocolType = protocolType;
            this.protocol = protocol;
            this.members = members;
        }

        public String state() {
            return this.state;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public String protocol() {
            return this.protocol;
        }

        public List<MemberMetadata.MemberSummary> members() {
            return this.members;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupSummary)) {
                return false;
            }
            GroupSummary other = (GroupSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$state = this.state();
            String other$state = other.state();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$protocolType = this.protocolType();
            String other$protocolType = other.protocolType();
            if (this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType)) {
                return false;
            }
            String this$protocol = this.protocol();
            String other$protocol = other.protocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            List<MemberMetadata.MemberSummary> this$members = this.members();
            List<MemberMetadata.MemberSummary> other$members = other.members();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupSummary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $state = this.state();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $protocolType = this.protocolType();
            result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
            String $protocol = this.protocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            List<MemberMetadata.MemberSummary> $members = this.members();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }

        public String toString() {
            return "GroupMetadata.GroupSummary(state=" + this.state() + ", protocolType=" + this.protocolType() + ", protocol=" + this.protocol() + ", members=" + this.members() + ")";
        }
    }

    public static class GroupOverview {
        private final String groupId;
        private final String protocolType;

        public GroupOverview(String groupId, String protocolType) {
            this.groupId = groupId;
            this.protocolType = protocolType;
        }

        public String groupId() {
            return this.groupId;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupOverview)) {
                return false;
            }
            GroupOverview other = (GroupOverview)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.groupId();
            String other$groupId = other.groupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$protocolType = this.protocolType();
            String other$protocolType = other.protocolType();
            return !(this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupOverview;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.groupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $protocolType = this.protocolType();
            result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
            return result;
        }

        public String toString() {
            return "GroupMetadata.GroupOverview(groupId=" + this.groupId() + ", protocolType=" + this.protocolType() + ")";
        }
    }

    static class CommitRecordMetadataAndOffset {
        private final Optional<PositionImpl> appendedPosition;
        private final OffsetAndMetadata offsetAndMetadata;

        public boolean olderThan(CommitRecordMetadataAndOffset that) {
            return this.appendedPosition.get().compareTo(that.appendedPosition.get()) < 0;
        }

        public CommitRecordMetadataAndOffset(Optional<PositionImpl> appendedPosition, OffsetAndMetadata offsetAndMetadata) {
            this.appendedPosition = appendedPosition;
            this.offsetAndMetadata = offsetAndMetadata;
        }

        public Optional<PositionImpl> appendedPosition() {
            return this.appendedPosition;
        }

        public OffsetAndMetadata offsetAndMetadata() {
            return this.offsetAndMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommitRecordMetadataAndOffset)) {
                return false;
            }
            CommitRecordMetadataAndOffset other = (CommitRecordMetadataAndOffset)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<PositionImpl> this$appendedPosition = this.appendedPosition();
            Optional<PositionImpl> other$appendedPosition = other.appendedPosition();
            if (this$appendedPosition == null ? other$appendedPosition != null : !((Object)this$appendedPosition).equals(other$appendedPosition)) {
                return false;
            }
            OffsetAndMetadata this$offsetAndMetadata = this.offsetAndMetadata();
            OffsetAndMetadata other$offsetAndMetadata = other.offsetAndMetadata();
            return !(this$offsetAndMetadata == null ? other$offsetAndMetadata != null : !((Object)this$offsetAndMetadata).equals(other$offsetAndMetadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommitRecordMetadataAndOffset;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<PositionImpl> $appendedPosition = this.appendedPosition();
            result = result * 59 + ($appendedPosition == null ? 43 : ((Object)$appendedPosition).hashCode());
            OffsetAndMetadata $offsetAndMetadata = this.offsetAndMetadata();
            result = result * 59 + ($offsetAndMetadata == null ? 43 : ((Object)$offsetAndMetadata).hashCode());
            return result;
        }

        public String toString() {
            return "GroupMetadata.CommitRecordMetadataAndOffset(appendedPosition=" + this.appendedPosition() + ", offsetAndMetadata=" + this.offsetAndMetadata() + ")";
        }
    }
}

