/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupMetadata;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupMetadataManager;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupState;
import io.streamnative.pulsar.handlers.kop.coordinator.group.MemberMetadata;
import io.streamnative.pulsar.handlers.kop.exceptions.KoPTopicException;
import io.streamnative.pulsar.handlers.kop.offset.OffsetAndMetadata;
import io.streamnative.pulsar.handlers.kop.utils.KopTopic;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.pulsar.common.schema.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupMetadataConstants {
    private static final Logger log = LoggerFactory.getLogger(GroupMetadataConstants.class);
    static final short CURRENT_OFFSET_KEY_SCHEMA_VERSION = 1;
    static final short CURRENT_GROUP_KEY_SCHEMA_VERSION = 2;
    static final Schema OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING), new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});
    static final BoundField OFFSET_KEY_GROUP_FIELD = OFFSET_COMMIT_KEY_SCHEMA.get("group");
    static final BoundField OFFSET_KEY_TOPIC_FIELD = OFFSET_COMMIT_KEY_SCHEMA.get("topic");
    static final BoundField OFFSET_KEY_PARTITION_FIELD = OFFSET_COMMIT_KEY_SCHEMA.get("partition");
    static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", (Type)Type.INT64)});
    static final BoundField OFFSET_VALUE_OFFSET_FIELD_V0 = OFFSET_COMMIT_VALUE_SCHEMA_V0.get("offset");
    static final BoundField OFFSET_VALUE_METADATA_FIELD_V0 = OFFSET_COMMIT_VALUE_SCHEMA_V0.get("metadata");
    static final BoundField OFFSET_VALUE_TIMESTAMP_FIELD_V0 = OFFSET_COMMIT_VALUE_SCHEMA_V0.get("timestamp");
    static final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", (Type)Type.INT64), new Field("expire_timestamp", (Type)Type.INT64)});
    static final BoundField OFFSET_VALUE_OFFSET_FIELD_V1 = OFFSET_COMMIT_VALUE_SCHEMA_V1.get("offset");
    static final BoundField OFFSET_VALUE_METADATA_FIELD_V1 = OFFSET_COMMIT_VALUE_SCHEMA_V1.get("metadata");
    static final BoundField OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = OFFSET_COMMIT_VALUE_SCHEMA_V1.get("commit_timestamp");
    static final BoundField OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = OFFSET_COMMIT_VALUE_SCHEMA_V1.get("expire_timestamp");
    static final Schema GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING)});
    static final BoundField GROUP_KEY_GROUP_FIELD = GROUP_METADATA_KEY_SCHEMA.get("group");
    static final String MEMBER_ID_KEY = "member_id";
    static final String CLIENT_ID_KEY = "client_id";
    static final String CLIENT_HOST_KEY = "client_host";
    static final String REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
    static final String SESSION_TIMEOUT_KEY = "session_timeout";
    static final String SUBSCRIPTION_KEY = "subscription";
    static final String ASSIGNMENT_KEY = "assignment";
    static final Schema MEMBER_METADATA_V0 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING), new Field("client_id", (Type)Type.STRING), new Field("client_host", (Type)Type.STRING), new Field("session_timeout", (Type)Type.INT32), new Field("subscription", (Type)Type.BYTES), new Field("assignment", (Type)Type.BYTES)});
    static final Schema MEMBER_METADATA_V1 = new Schema(new Field[]{new Field("member_id", (Type)Type.STRING), new Field("client_id", (Type)Type.STRING), new Field("client_host", (Type)Type.STRING), new Field("rebalance_timeout", (Type)Type.INT32), new Field("session_timeout", (Type)Type.INT32), new Field("subscription", (Type)Type.BYTES), new Field("assignment", (Type)Type.BYTES)});
    static final String PROTOCOL_TYPE_KEY = "protocol_type";
    static final String GENERATION_KEY = "generation";
    static final String PROTOCOL_KEY = "protocol";
    static final String LEADER_KEY = "leader";
    static final String MEMBERS_KEY = "members";
    static final Schema GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.STRING), new Field("generation", (Type)Type.INT32), new Field("protocol", (Type)Type.NULLABLE_STRING), new Field("leader", (Type)Type.NULLABLE_STRING), new Field("members", (Type)new ArrayOf((Type)MEMBER_METADATA_V0))});
    static final Schema GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("protocol_type", (Type)Type.STRING), new Field("generation", (Type)Type.INT32), new Field("protocol", (Type)Type.NULLABLE_STRING), new Field("leader", (Type)Type.NULLABLE_STRING), new Field("members", (Type)new ArrayOf((Type)MEMBER_METADATA_V1))});
    static final Map<Integer, Schema> MESSAGE_TYPE_SCHEMAS = GroupMetadataConstants.asMap(GroupMetadataConstants.kv(0, OFFSET_COMMIT_KEY_SCHEMA), GroupMetadataConstants.kv(1, OFFSET_COMMIT_KEY_SCHEMA), GroupMetadataConstants.kv(2, GROUP_METADATA_KEY_SCHEMA));
    static final Map<Integer, Schema> OFFSET_VALUE_SCHEMAS = GroupMetadataConstants.asMap(GroupMetadataConstants.kv(0, OFFSET_COMMIT_VALUE_SCHEMA_V0), GroupMetadataConstants.kv(1, OFFSET_COMMIT_VALUE_SCHEMA_V1));
    static final short CURRENT_OFFSET_VALUE_SCHEMA_VERSION = 1;
    static final Map<Integer, Schema> GROUP_VALUE_SCHEMAS = GroupMetadataConstants.asMap(GroupMetadataConstants.kv(0, GROUP_METADATA_VALUE_SCHEMA_V0), GroupMetadataConstants.kv(1, GROUP_METADATA_VALUE_SCHEMA_V1));
    static final short CURRENT_GROUP_VALUE_SCHEMA_VERSION = 1;
    static final Schema CURRENT_OFFSET_KEY_SCHEMA = GroupMetadataConstants.schemaForKey(1);
    static final Schema CURRENT_GROUP_KEY_SCHEMA = GroupMetadataConstants.schemaForKey(2);
    static final Schema CURRENT_OFFSET_VALUE_SCHEMA = GroupMetadataConstants.schemaForOffset(1);
    static final Schema CURRENT_GROUP_VALUE_SCHEMA = GroupMetadataConstants.schemaForGroup(1);

    private static Schema schemaForKey(int version) {
        Schema schema = MESSAGE_TYPE_SCHEMAS.get(version);
        if (null == schema) {
            throw new KafkaException("Unknown offset schema version " + version);
        }
        return schema;
    }

    private static Schema schemaForOffset(int version) {
        Schema schema = OFFSET_VALUE_SCHEMAS.get(version);
        if (null == schema) {
            throw new KafkaException("Unknown offset schema version " + version);
        }
        return schema;
    }

    private static Schema schemaForGroup(int version) {
        Schema schema = GROUP_VALUE_SCHEMAS.get(version);
        if (null == schema) {
            throw new KafkaException("Unknown group metadata version " + version);
        }
        return schema;
    }

    private static <K, V> KeyValue<K, V> kv(K key, V value) {
        return new KeyValue(key, value);
    }

    private static <K, V> Map<K, V> asMap(KeyValue<K, V> ... kvs) {
        return Lists.newArrayList((Object[])kvs).stream().collect(Collectors.toMap(KeyValue::getKey, KeyValue::getValue));
    }

    static byte[] offsetCommitKey(String group, TopicPartition topicPartition, String namespacePrefix) {
        return GroupMetadataConstants.offsetCommitKey(group, topicPartition, namespacePrefix, (short)0);
    }

    static byte[] offsetCommitKey(String group, TopicPartition topicPartition, String namespacePrefix, short versionId) {
        if (topicPartition.partition() >= 0 && !KopTopic.isFullTopicName(topicPartition.topic())) {
            try {
                topicPartition = new TopicPartition(new KopTopic(topicPartition.topic(), namespacePrefix).getFullName(), topicPartition.partition());
            }
            catch (KoPTopicException e) {
                log.warn("Invalid topic name: {}", (Object)topicPartition.topic(), (Object)e);
                return null;
            }
        }
        Struct key = new Struct(CURRENT_OFFSET_KEY_SCHEMA);
        key.set(OFFSET_KEY_GROUP_FIELD, (Object)group);
        key.set(OFFSET_KEY_TOPIC_FIELD, (Object)topicPartition.topic());
        key.set(OFFSET_KEY_PARTITION_FIELD, (Object)topicPartition.partition());
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort((short)1);
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    static byte[] groupMetadataKey(String group) {
        Struct key = new Struct(CURRENT_GROUP_KEY_SCHEMA);
        key.set(GROUP_KEY_GROUP_FIELD, (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort((short)2);
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    static byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata) {
        Struct value = new Struct(CURRENT_OFFSET_VALUE_SCHEMA);
        value.set(OFFSET_VALUE_OFFSET_FIELD_V1, (Object)offsetAndMetadata.offset());
        value.set(OFFSET_VALUE_METADATA_FIELD_V1, (Object)offsetAndMetadata.metadata());
        value.set(OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1, (Object)offsetAndMetadata.commitTimestamp());
        value.set(OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1, (Object)offsetAndMetadata.expireTimestamp());
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort((short)1);
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    static byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment) {
        return GroupMetadataConstants.groupMetadataValue(groupMetadata, assignment, (short)0);
    }

    static byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, short version) {
        Struct value = version == 0 ? new Struct(GROUP_METADATA_VALUE_SCHEMA_V0) : new Struct(CURRENT_GROUP_VALUE_SCHEMA);
        value.set(PROTOCOL_TYPE_KEY, (Object)groupMetadata.protocolType().orElse(""));
        value.set(GENERATION_KEY, (Object)groupMetadata.generationId());
        value.set(PROTOCOL_KEY, (Object)groupMetadata.protocolOrNull());
        value.set(LEADER_KEY, (Object)groupMetadata.leaderOrNull());
        value.set(MEMBERS_KEY, (Object)groupMetadata.allMemberMetadata().stream().map(memberMetadata -> {
            String protocol;
            Struct memberStruct = value.instance(MEMBERS_KEY);
            memberStruct.set(MEMBER_ID_KEY, (Object)memberMetadata.memberId());
            memberStruct.set(CLIENT_ID_KEY, (Object)memberMetadata.clientId());
            memberStruct.set(CLIENT_HOST_KEY, (Object)memberMetadata.clientHost());
            memberStruct.set(SESSION_TIMEOUT_KEY, (Object)memberMetadata.sessionTimeoutMs());
            if (version > 0) {
                memberStruct.set(REBALANCE_TIMEOUT_KEY, (Object)memberMetadata.rebalanceTimeoutMs());
            }
            if ((protocol = groupMetadata.protocolOrNull()) == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol");
            }
            byte[] metadata = memberMetadata.metadata(protocol);
            memberStruct.set(SUBSCRIPTION_KEY, (Object)ByteBuffer.wrap(metadata));
            byte[] memberAssignment = (byte[])assignment.get(memberMetadata.memberId());
            Preconditions.checkState((memberAssignment != null ? 1 : 0) != 0, (String)"Member assignment is null for member %s", (Object)memberMetadata.memberId());
            memberStruct.set(ASSIGNMENT_KEY, (Object)ByteBuffer.wrap(memberAssignment));
            return memberStruct;
        }).toArray());
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(version);
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public static GroupMetadataManager.BaseKey readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Schema keySchema = GroupMetadataConstants.schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version <= 1) {
            String group = key.getString(OFFSET_KEY_GROUP_FIELD);
            String topic = key.getString(OFFSET_KEY_TOPIC_FIELD);
            int partition = key.getInt(OFFSET_KEY_PARTITION_FIELD);
            return new GroupMetadataManager.OffsetKey(version, new GroupMetadataManager.GroupTopicPartition(group, topic, partition));
        }
        if (version == 2) {
            String group = key.getString(GROUP_KEY_GROUP_FIELD);
            return new GroupMetadataManager.GroupMetadataKey(version, group);
        }
        throw new IllegalStateException("Unknown version " + version + " for group metadata message");
    }

    public static OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        short version = buffer.getShort();
        Schema valueSchema = GroupMetadataConstants.schemaForOffset(version);
        Struct value = valueSchema.read(buffer);
        if (version == 0) {
            long offset = value.getLong(OFFSET_VALUE_OFFSET_FIELD_V0);
            String metadata = value.getString(OFFSET_VALUE_METADATA_FIELD_V0);
            long timestamp = value.getLong(OFFSET_VALUE_TIMESTAMP_FIELD_V0);
            return OffsetAndMetadata.apply(offset, metadata, timestamp);
        }
        if (version == 1) {
            long offset = value.getLong(OFFSET_VALUE_OFFSET_FIELD_V1);
            String metadata = value.getString(OFFSET_VALUE_METADATA_FIELD_V1);
            long commitTimestamp = value.getLong(OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1);
            long expireTimestamp = value.getLong(OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1);
            return OffsetAndMetadata.apply(offset, metadata, commitTimestamp, expireTimestamp);
        }
        throw new IllegalStateException("Unknown offset message version " + version);
    }

    static GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        short version = buffer.getShort();
        Schema valueSchema = GroupMetadataConstants.schemaForGroup(version);
        Struct value = valueSchema.read(buffer);
        if (version == 0 || version == 1) {
            int generationId = value.getInt(GENERATION_KEY);
            String protocolType = value.getString(PROTOCOL_TYPE_KEY);
            String protocol = value.getString(PROTOCOL_KEY);
            String leaderId = value.getString(LEADER_KEY);
            Object[] memberMetadataArray = value.getArray(MEMBERS_KEY);
            GroupState initialState = memberMetadataArray.length == 0 ? GroupState.Empty : GroupState.Stable;
            List<MemberMetadata> members = Lists.newArrayList((Object[])memberMetadataArray).stream().map(memberMetadataObj -> {
                Struct memberMetadata = (Struct)memberMetadataObj;
                String memberId = memberMetadata.getString(MEMBER_ID_KEY);
                String clientId = memberMetadata.getString(CLIENT_ID_KEY);
                String clientHost = memberMetadata.getString(CLIENT_HOST_KEY);
                int sessionTimeout = memberMetadata.getInt(SESSION_TIMEOUT_KEY);
                int rebalanceTimeout = version == 0 ? sessionTimeout : memberMetadata.getInt(REBALANCE_TIMEOUT_KEY);
                ByteBuffer subscription = memberMetadata.getBytes(SUBSCRIPTION_KEY);
                byte[] subscriptionData = new byte[subscription.remaining()];
                subscription.get(subscriptionData);
                HashMap<String, byte[]> protocols = new HashMap<String, byte[]>();
                protocols.put(protocol, subscriptionData);
                return new MemberMetadata(memberId, groupId, clientId, clientHost, rebalanceTimeout, sessionTimeout, protocolType, protocols);
            }).collect(Collectors.toList());
            return GroupMetadata.loadGroup(groupId, initialState, generationId, protocolType, protocol, leaderId, members);
        }
        throw new IllegalStateException("Unknown group metadata message version");
    }

    private GroupMetadataConstants() {
    }
}

