/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.group;

import com.google.common.collect.Lists;
import io.streamnative.pulsar.handlers.kop.coordinator.group.DelayedJoin;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupCoordinator;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupMetadata;
import io.streamnative.pulsar.handlers.kop.utils.delayed.DelayedOperationKey;
import io.streamnative.pulsar.handlers.kop.utils.delayed.DelayedOperationPurgatory;

class InitialDelayedJoin
extends DelayedJoin {
    final DelayedOperationPurgatory<DelayedJoin> purgatory;
    final int configuredRebalanceDelay;
    final int delayMs;
    final int remainingMs;

    InitialDelayedJoin(GroupCoordinator coordinator, DelayedOperationPurgatory<DelayedJoin> purgatory, GroupMetadata group, int configuredRebalanceDelay, int delayMs, int remainingMs) {
        super(coordinator, group, delayMs);
        this.purgatory = purgatory;
        this.configuredRebalanceDelay = configuredRebalanceDelay;
        this.delayMs = delayMs;
        this.remainingMs = remainingMs;
    }

    @Override
    public void onComplete() {
        this.group.inLock(() -> {
            if (this.group.newMemberAdded() && this.remainingMs != 0) {
                this.group.newMemberAdded(false);
                int delay = Math.min(this.configuredRebalanceDelay, this.remainingMs);
                int remaining = Math.max(this.remainingMs - this.delayMs, 0);
                this.purgatory.tryCompleteElseWatch(new InitialDelayedJoin(this.coordinator, this.purgatory, this.group, this.configuredRebalanceDelay, delay, remaining), Lists.newArrayList((Object[])new Object[]{new DelayedOperationKey.GroupKey(this.group.groupId())}));
            } else {
                super.onComplete();
            }
            return null;
        });
    }

    @Override
    public boolean tryComplete() {
        return false;
    }
}

