/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.streamnative.pulsar.handlers.kop.coordinator.group.JoinGroupResult;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.common.protocol.Errors;

@NotThreadSafe
@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class MemberMetadata {
    private final String memberId;
    private final String groupId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private final String protocolType;
    private final Map<String, byte[]> supportedProtocols;
    private byte[] assignment = new byte[0];
    private CompletableFuture<JoinGroupResult> awaitingJoinCallback = null;
    private BiConsumer<byte[], Errors> awaitingSyncCallback = null;
    private long latestHeartbeat = -1L;
    private boolean isLeaving = false;

    public Set<String> protocols() {
        return this.supportedProtocols.keySet();
    }

    public void supportedProtocols(Map<String, byte[]> supportedProtocols) {
        this.supportedProtocols.clear();
        this.supportedProtocols.putAll(supportedProtocols);
    }

    public byte[] metadata(String protocol) {
        byte[] metadata = this.supportedProtocols.get(protocol);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"Member does not support protocol");
        return metadata;
    }

    public boolean matches(Map<String, byte[]> protocols) {
        if (protocols.size() != this.supportedProtocols.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> protocolEntry : protocols.entrySet()) {
            byte[] p1 = protocolEntry.getValue();
            byte[] p2 = this.supportedProtocols.get(protocolEntry.getKey());
            if (p2 != null && Arrays.equals(p1, p2)) continue;
            return false;
        }
        return true;
    }

    public MemberSummary summary(String protocol) {
        return new MemberSummary(this.memberId, this.clientId, this.clientHost, this.metadata(protocol), this.assignment);
    }

    public MemberSummary summaryNoMetadata() {
        return new MemberSummary(this.memberId, this.clientId, this.clientHost, new byte[0], new byte[0]);
    }

    public String vote(Set<String> candidates) {
        Optional<Map.Entry> voteProtocol = this.supportedProtocols.entrySet().stream().filter(p -> candidates.contains(p.getKey())).findFirst();
        Preconditions.checkArgument((boolean)voteProtocol.isPresent(), (Object)"Member does not support any of the candidate protocols");
        return (String)voteProtocol.get().getKey();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MemberMetadata").add("memberId", (Object)this.memberId).add("clientId", (Object)this.clientId).add("clientHost", (Object)this.clientHost).add("sessionTimeoutMs", this.sessionTimeoutMs).add("rebalanceTimeoutMs", this.rebalanceTimeoutMs).add("supportedProtocols", this.protocols().stream());
        return helper.toString();
    }

    public MemberMetadata(String memberId, String groupId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, Map<String, byte[]> supportedProtocols) {
        this.memberId = memberId;
        this.groupId = groupId;
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.protocolType = protocolType;
        this.supportedProtocols = supportedProtocols;
    }

    public String memberId() {
        return this.memberId;
    }

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public Map<String, byte[]> supportedProtocols() {
        return this.supportedProtocols;
    }

    public byte[] assignment() {
        return this.assignment;
    }

    public CompletableFuture<JoinGroupResult> awaitingJoinCallback() {
        return this.awaitingJoinCallback;
    }

    public BiConsumer<byte[], Errors> awaitingSyncCallback() {
        return this.awaitingSyncCallback;
    }

    public long latestHeartbeat() {
        return this.latestHeartbeat;
    }

    public boolean isLeaving() {
        return this.isLeaving;
    }

    public MemberMetadata assignment(byte[] assignment) {
        this.assignment = assignment;
        return this;
    }

    public MemberMetadata awaitingJoinCallback(CompletableFuture<JoinGroupResult> awaitingJoinCallback) {
        this.awaitingJoinCallback = awaitingJoinCallback;
        return this;
    }

    public MemberMetadata awaitingSyncCallback(BiConsumer<byte[], Errors> awaitingSyncCallback) {
        this.awaitingSyncCallback = awaitingSyncCallback;
        return this;
    }

    public MemberMetadata latestHeartbeat(long latestHeartbeat) {
        this.latestHeartbeat = latestHeartbeat;
        return this;
    }

    public MemberMetadata isLeaving(boolean isLeaving) {
        this.isLeaving = isLeaving;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class MemberSummary {
        private final String memberId;
        private final String clientId;
        private final String clientHost;
        private final byte[] metadata;
        private final byte[] assignment;

        public MemberSummary(String memberId, String clientId, String clientHost, byte[] metadata, byte[] assignment) {
            this.memberId = memberId;
            this.clientId = clientId;
            this.clientHost = clientHost;
            this.metadata = metadata;
            this.assignment = assignment;
        }

        public String memberId() {
            return this.memberId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        public byte[] assignment() {
            return this.assignment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberSummary)) {
                return false;
            }
            MemberSummary other = (MemberSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$memberId = this.memberId();
            String other$memberId = other.memberId();
            if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
                return false;
            }
            String this$clientId = this.clientId();
            String other$clientId = other.clientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientHost = this.clientHost();
            String other$clientHost = other.clientHost();
            if (this$clientHost == null ? other$clientHost != null : !this$clientHost.equals(other$clientHost)) {
                return false;
            }
            if (!Arrays.equals(this.metadata(), other.metadata())) {
                return false;
            }
            return Arrays.equals(this.assignment(), other.assignment());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MemberSummary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $memberId = this.memberId();
            result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
            String $clientId = this.clientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientHost = this.clientHost();
            result = result * 59 + ($clientHost == null ? 43 : $clientHost.hashCode());
            result = result * 59 + Arrays.hashCode(this.metadata());
            result = result * 59 + Arrays.hashCode(this.assignment());
            return result;
        }

        public String toString() {
            return "MemberMetadata.MemberSummary(memberId=" + this.memberId() + ", clientId=" + this.clientId() + ", clientHost=" + this.clientHost() + ", metadata=" + Arrays.toString(this.metadata()) + ", assignment=" + Arrays.toString(this.assignment()) + ")";
        }
    }
}

