/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.transaction;

import io.streamnative.pulsar.handlers.kop.coordinator.transaction.ResponseContext;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.KopResponseUtils;
import org.apache.kafka.common.requests.RequestHeader;

public class PendingRequest {
    private static final String CLIENT_ID = "kop-internal-txn-client";
    private final RequestHeader requestHeader;
    private final AbstractRequest request;
    private final Consumer<ResponseContext> responseConsumerHandler;
    private final CompletableFuture<AbstractResponse> sendFuture = new CompletableFuture();

    public PendingRequest(ApiKeys apiKeys, int correlationId, AbstractRequest request, Consumer<ResponseContext> responseConsumerHandler) {
        this.requestHeader = new RequestHeader(apiKeys, apiKeys.latestVersion(), CLIENT_ID, correlationId);
        this.request = request;
        this.responseConsumerHandler = responseConsumerHandler;
    }

    public ByteBuffer serialize() {
        return KopResponseUtils.serializeRequest(this.requestHeader, this.request);
    }

    public AbstractResponse parseResponse(ByteBuffer buffer) {
        return AbstractResponse.parseResponse((ByteBuffer)buffer, (RequestHeader)this.requestHeader);
    }

    public short getApiVersion() {
        return this.requestHeader.apiVersion();
    }

    public int getCorrelationId() {
        return this.requestHeader.correlationId();
    }

    public void complete(ResponseContext responseContext) {
        this.responseConsumerHandler.accept(responseContext);
        this.sendFuture.complete(responseContext.getResponse());
    }

    public void completeExceptionally(Throwable throwable) {
        this.sendFuture.completeExceptionally(throwable);
    }

    public String toString() {
        return this.requestHeader.toString();
    }

    public CompletableFuture<AbstractResponse> getSendFuture() {
        return this.sendFuture;
    }
}

