/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.transaction;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class TransactionLogKey {
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;
    private final String transactionId;
    private static final String TXN_ID_FIELD = "transactional_id";
    protected static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("transactional_id", (Type)Type.STRING, "")});
    private static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public static Schema getSchema(short schemaVersion) {
        return SCHEMAS[schemaVersion];
    }

    public byte[] toBytes() {
        return this.toBytes((short)0);
    }

    public byte[] toBytes(short schemaVersion) {
        Struct struct = new Struct(TransactionLogKey.getSchema(schemaVersion));
        struct.set(TXN_ID_FIELD, (Object)this.transactionId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + struct.sizeOf());
        byteBuffer.putShort(schemaVersion);
        struct.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public static TransactionLogKey decode(ByteBuffer byteBuffer, short schemaVersion) {
        Schema schema = TransactionLogKey.getSchema(schemaVersion);
        byteBuffer.getShort();
        Struct struct = schema.read(byteBuffer);
        return new TransactionLogKey(struct.getString(TXN_ID_FIELD));
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionLogKey)) {
            return false;
        }
        TransactionLogKey other = (TransactionLogKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionLogKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionLogKey(transactionId=" + this.getTransactionId() + ")";
    }

    public TransactionLogKey(String transactionId) {
        this.transactionId = transactionId;
    }
}

