/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.streamnative.pulsar.handlers.kop.coordinator.transaction.TransactionMetadata;
import io.streamnative.pulsar.handlers.kop.coordinator.transaction.TransactionState;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class TransactionLogValue {
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;
    private final long producerId;
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final byte transactionStatus;
    private final List<PartitionsSchema> transactionPartitions;
    private final long transactionLastUpdateTimestampMs;
    private final long transactionStartTimestampMs;
    private static final String PRODUCER_ID_FIELD = "producer_id";
    private static final String PRODUCER_EPOCH_FIELD = "producer_epoch";
    private static final String TXN_TIMEOUT_MS_FIELD = "transaction_timeout_ms";
    private static final String TXN_STATUS_FIELD = "transaction_status";
    private static final String TXN_PARTITIONS_FIELD = "transaction_partitions";
    private static final String TXN_LAST_UPDATE_TIMESTAMP_FIELD = "transaction_last_update_timestamp_ms";
    private static final String TXN_START_TIMESTAMP_FIELD = "transaction_start_timestamp_ms";
    private static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "Producer id in use by the transactional id"), new Field("producer_epoch", (Type)Type.INT16, "Epoch associated with the producer id"), new Field("transaction_timeout_ms", (Type)Type.INT32, "Transaction timeout in milliseconds"), new Field("transaction_status", (Type)Type.INT8, "TransactionState the transaction is in"), new Field("transaction_partitions", (Type)ArrayOf.nullable((Type)PartitionsSchema.SCHEMA_0), "Set of partitions involved in the transaction"), new Field("transaction_last_update_timestamp_ms", (Type)Type.INT64, "Time the transaction was last updated"), new Field("transaction_start_timestamp_ms", (Type)Type.INT64, "Time the transaction was started")});
    private static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public TransactionLogValue(TransactionMetadata.TxnTransitMetadata txnTransitMetadata) {
        if (txnTransitMetadata.getTxnState() == TransactionState.EMPTY && !txnTransitMetadata.getTopicPartitions().isEmpty()) {
            throw new IllegalStateException("Transaction is not expected to have any partitions since its state is " + txnTransitMetadata.getTxnState() + ":" + txnTransitMetadata.toString());
        }
        this.producerId = txnTransitMetadata.getProducerId();
        this.producerEpoch = txnTransitMetadata.getProducerEpoch();
        this.transactionTimeoutMs = txnTransitMetadata.getTxnTimeoutMs();
        this.transactionStatus = txnTransitMetadata.getTxnState().getValue();
        this.transactionPartitions = txnTransitMetadata.getTopicPartitions().stream().map(partition -> new PartitionsSchema(partition.topic(), Lists.newArrayList((Object[])new Integer[]{partition.partition()}))).collect(Collectors.toList());
        this.transactionLastUpdateTimestampMs = txnTransitMetadata.getTxnLastUpdateTimestamp();
        this.transactionStartTimestampMs = txnTransitMetadata.getTxnStartTimestamp();
    }

    public static Schema getSchema(short schemaVersion) {
        return SCHEMAS[schemaVersion];
    }

    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer((short)0);
    }

    public ByteBuffer toByteBuffer(short schemaVersion) {
        if (this.getTransactionStatus() == TransactionState.EMPTY.getValue() && !this.transactionPartitions.isEmpty()) {
            throw new IllegalStateException("Transaction is not expected to have any partitions since its state is " + this.transactionStatus);
        }
        Struct struct = new Struct(TransactionLogValue.getSchema(schemaVersion));
        struct.set(PRODUCER_ID_FIELD, (Object)this.producerId);
        struct.set(PRODUCER_EPOCH_FIELD, (Object)this.producerEpoch);
        struct.set(TXN_TIMEOUT_MS_FIELD, (Object)this.transactionTimeoutMs);
        struct.set(TXN_STATUS_FIELD, (Object)this.transactionStatus);
        struct.set(TXN_PARTITIONS_FIELD, (Object)this.transactionPartitions.stream().map(PartitionsSchema::toStruct).toArray());
        struct.set(TXN_LAST_UPDATE_TIMESTAMP_FIELD, (Object)this.transactionLastUpdateTimestampMs);
        struct.set(TXN_START_TIMESTAMP_FIELD, (Object)this.transactionStartTimestampMs);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + struct.sizeOf());
        byteBuffer.putShort(schemaVersion);
        struct.writeTo(byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static TransactionLogValue decode(ByteBuffer byteBuffer, short schemaVersion) {
        Schema schema = TransactionLogValue.getSchema(schemaVersion);
        byteBuffer.getShort();
        Struct struct = schema.read(byteBuffer);
        List<PartitionsSchema> partitionsSchemas = Arrays.stream(struct.getArray(TXN_PARTITIONS_FIELD)).map(obj -> PartitionsSchema.fromStruct((Struct)obj)).collect(Collectors.toList());
        return new TransactionLogValue(struct.getLong(PRODUCER_ID_FIELD), struct.getShort(PRODUCER_EPOCH_FIELD), struct.getInt(TXN_TIMEOUT_MS_FIELD), struct.getByte(TXN_STATUS_FIELD), partitionsSchemas, struct.getLong(TXN_LAST_UPDATE_TIMESTAMP_FIELD), struct.getLong(TXN_START_TIMESTAMP_FIELD));
    }

    public static TransactionMetadata readTxnRecordValue(String transactionalId, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        TransactionLogValue value = TransactionLogValue.decode(byteBuffer, (short)0);
        TransactionMetadata metadata = TransactionMetadata.builder().transactionalId(transactionalId).producerId(value.getProducerId()).lastProducerId(-1L).producerEpoch(value.getProducerEpoch()).lastProducerEpoch((short)-1).txnTimeoutMs(value.getTransactionTimeoutMs()).state(TransactionState.byteToState(value.getTransactionStatus())).topicPartitions(Sets.newHashSet()).txnStartTimestamp(value.getTransactionStartTimestampMs()).txnLastUpdateTimestamp(value.getTransactionLastUpdateTimestampMs()).build();
        if (!metadata.getState().equals((Object)TransactionState.EMPTY)) {
            value.getTransactionPartitions().forEach(partitionsSchema -> metadata.addPartitions(partitionsSchema.getPartitionIds().stream().map(partition -> new TopicPartition(partitionsSchema.getTopic(), partition.intValue())).collect(Collectors.toSet())));
        }
        return metadata;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public short getProducerEpoch() {
        return this.producerEpoch;
    }

    public int getTransactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public byte getTransactionStatus() {
        return this.transactionStatus;
    }

    public List<PartitionsSchema> getTransactionPartitions() {
        return this.transactionPartitions;
    }

    public long getTransactionLastUpdateTimestampMs() {
        return this.transactionLastUpdateTimestampMs;
    }

    public long getTransactionStartTimestampMs() {
        return this.transactionStartTimestampMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionLogValue)) {
            return false;
        }
        TransactionLogValue other = (TransactionLogValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProducerId() != other.getProducerId()) {
            return false;
        }
        if (this.getProducerEpoch() != other.getProducerEpoch()) {
            return false;
        }
        if (this.getTransactionTimeoutMs() != other.getTransactionTimeoutMs()) {
            return false;
        }
        if (this.getTransactionStatus() != other.getTransactionStatus()) {
            return false;
        }
        if (this.getTransactionLastUpdateTimestampMs() != other.getTransactionLastUpdateTimestampMs()) {
            return false;
        }
        if (this.getTransactionStartTimestampMs() != other.getTransactionStartTimestampMs()) {
            return false;
        }
        List<PartitionsSchema> this$transactionPartitions = this.getTransactionPartitions();
        List<PartitionsSchema> other$transactionPartitions = other.getTransactionPartitions();
        return !(this$transactionPartitions == null ? other$transactionPartitions != null : !((Object)this$transactionPartitions).equals(other$transactionPartitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionLogValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $producerId = this.getProducerId();
        result = result * 59 + (int)($producerId >>> 32 ^ $producerId);
        result = result * 59 + this.getProducerEpoch();
        result = result * 59 + this.getTransactionTimeoutMs();
        result = result * 59 + this.getTransactionStatus();
        long $transactionLastUpdateTimestampMs = this.getTransactionLastUpdateTimestampMs();
        result = result * 59 + (int)($transactionLastUpdateTimestampMs >>> 32 ^ $transactionLastUpdateTimestampMs);
        long $transactionStartTimestampMs = this.getTransactionStartTimestampMs();
        result = result * 59 + (int)($transactionStartTimestampMs >>> 32 ^ $transactionStartTimestampMs);
        List<PartitionsSchema> $transactionPartitions = this.getTransactionPartitions();
        result = result * 59 + ($transactionPartitions == null ? 43 : ((Object)$transactionPartitions).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionLogValue(producerId=" + this.getProducerId() + ", producerEpoch=" + this.getProducerEpoch() + ", transactionTimeoutMs=" + this.getTransactionTimeoutMs() + ", transactionStatus=" + this.getTransactionStatus() + ", transactionPartitions=" + this.getTransactionPartitions() + ", transactionLastUpdateTimestampMs=" + this.getTransactionLastUpdateTimestampMs() + ", transactionStartTimestampMs=" + this.getTransactionStartTimestampMs() + ")";
    }

    public TransactionLogValue(long producerId, short producerEpoch, int transactionTimeoutMs, byte transactionStatus, List<PartitionsSchema> transactionPartitions, long transactionLastUpdateTimestampMs, long transactionStartTimestampMs) {
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.transactionStatus = transactionStatus;
        this.transactionPartitions = transactionPartitions;
        this.transactionLastUpdateTimestampMs = transactionLastUpdateTimestampMs;
        this.transactionStartTimestampMs = transactionStartTimestampMs;
    }

    public static class PartitionsSchema {
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;
        private String topic;
        private List<Integer> partitionIds;
        private static final String TOPIC_FIELD = "topic";
        private static final String PARTITION_IDS_FIELD = "partition_ids";
        private static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, ""), new Field("partition_ids", (Type)new ArrayOf((Type)Type.INT32), "")});
        private static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public static Schema getSchema(short schemaVersion) {
            return SCHEMAS[schemaVersion];
        }

        public Struct toStruct() {
            Struct struct = new Struct(PartitionsSchema.getSchema((short)0));
            struct.set(TOPIC_FIELD, (Object)this.topic);
            struct.set(PARTITION_IDS_FIELD, (Object)this.partitionIds.toArray());
            return struct;
        }

        public static PartitionsSchema fromStruct(Struct struct) {
            return new PartitionsSchema(struct.getString(TOPIC_FIELD), Arrays.stream(struct.getArray(PARTITION_IDS_FIELD)).map(id -> (Integer)id).collect(Collectors.toList()));
        }

        public byte[] toBytes(short schemaVersion) {
            Struct struct = new Struct(PartitionsSchema.getSchema(schemaVersion));
            struct.set(TOPIC_FIELD, (Object)this.topic);
            struct.set(PARTITION_IDS_FIELD, this.partitionIds);
            ByteBuffer byteBuffer = ByteBuffer.allocate(2 + struct.sizeOf());
            byteBuffer.putShort(schemaVersion);
            struct.writeTo(byteBuffer);
            return byteBuffer.array();
        }

        public static PartitionsSchema decode(ByteBuf byteBuf, short schemaVersion) {
            Schema schema = PartitionsSchema.getSchema(schemaVersion);
            byteBuf.readShort();
            Struct struct = schema.read(byteBuf.nioBuffer());
            Object[] partitionIdObjects = struct.getArray(PARTITION_IDS_FIELD);
            return new PartitionsSchema(struct.getString(TOPIC_FIELD), Arrays.stream(partitionIdObjects).map(o -> (Integer)o).collect(Collectors.toList()));
        }

        public String getTopic() {
            return this.topic;
        }

        public List<Integer> getPartitionIds() {
            return this.partitionIds;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPartitionIds(List<Integer> partitionIds) {
            this.partitionIds = partitionIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartitionsSchema)) {
                return false;
            }
            PartitionsSchema other = (PartitionsSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            List<Integer> this$partitionIds = this.getPartitionIds();
            List<Integer> other$partitionIds = other.getPartitionIds();
            return !(this$partitionIds == null ? other$partitionIds != null : !((Object)this$partitionIds).equals(other$partitionIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartitionsSchema;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            List<Integer> $partitionIds = this.getPartitionIds();
            result = result * 59 + ($partitionIds == null ? 43 : ((Object)$partitionIds).hashCode());
            return result;
        }

        public String toString() {
            return "TransactionLogValue.PartitionsSchema(topic=" + this.getTopic() + ", partitionIds=" + this.getPartitionIds() + ")";
        }

        public PartitionsSchema(String topic, List<Integer> partitionIds) {
            this.topic = topic;
            this.partitionIds = partitionIds;
        }
    }
}

