/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.transaction;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslHandler;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import io.streamnative.pulsar.handlers.kop.coordinator.transaction.TransactionMarkerChannelHandler;
import io.streamnative.pulsar.handlers.kop.coordinator.transaction.TransactionMarkerChannelManager;
import io.streamnative.pulsar.handlers.kop.utils.ssl.SSLUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TransactionMarkerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final boolean enableTls;
    private final SslContextFactory.Client sslContextFactory;
    private final TransactionMarkerChannelManager transactionMarkerChannelManager;
    private final LengthFieldPrepender lengthFieldPrepender;

    public TransactionMarkerChannelInitializer(KafkaServiceConfiguration kafkaConfig, boolean enableTls, TransactionMarkerChannelManager transactionMarkerChannelManager) {
        this.enableTls = enableTls;
        this.transactionMarkerChannelManager = transactionMarkerChannelManager;
        this.sslContextFactory = enableTls ? SSLUtils.createClientSslContextFactory(kafkaConfig) : null;
        this.lengthFieldPrepender = new LengthFieldPrepender(4);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTls) {
            ch.pipeline().addLast("tls", (ChannelHandler)new SslHandler(SSLUtils.createClientSslEngine(this.sslContextFactory)));
        }
        ch.pipeline().addLast(new ChannelHandler[]{this.lengthFieldPrepender});
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x6400000, 0, 4, 0, 4));
        ch.pipeline().addLast("txnHandler", (ChannelHandler)new TransactionMarkerChannelHandler(this.transactionMarkerChannelManager));
    }
}

