/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.transaction;

import com.google.common.collect.Sets;
import io.streamnative.pulsar.handlers.kop.coordinator.transaction.TransactionState;
import io.streamnative.pulsar.handlers.kop.scala.Either;
import io.streamnative.pulsar.handlers.kop.utils.CoreUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionMetadata {
    private static final Logger log = LoggerFactory.getLogger(TransactionMetadata.class);
    private static final int DefaultTxnTimeOutMs = 60000;
    private String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs = 60000;
    private TransactionState state;
    private Set<TopicPartition> topicPartitions;
    private long txnStartTimestamp;
    private long txnLastUpdateTimestamp;
    private Optional<TransactionState> pendingState;
    private boolean hasFailedEpochFence = false;
    private final ReentrantLock lock = new ReentrantLock();
    private static Map<TransactionState, Set<TransactionState>> validPreviousStates = new HashMap<TransactionState, Set<TransactionState>>();

    public <T> T inLock(Supplier<T> supplier) {
        return CoreUtils.inLock(this.lock, supplier);
    }

    public TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState.isPresent()) {
            throw new IllegalStateException("Preparing transaction state transition to " + newState + " while it already a pending state " + (Object)((Object)this.pendingState.get()));
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException("Illegal new producer id $newProducerId");
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException("Illegal new producer epoch $newEpoch");
        }
        if (validPreviousStates.get((Object)newState).contains((Object)this.state)) {
            TxnTransitMetadata txnTransitMetadata = TxnTransitMetadata.builder().producerId(newProducerId).lastProducerId(this.producerId).producerEpoch(newEpoch).lastProducerEpoch(newLastEpoch).txnTimeoutMs(newTxnTimeoutMs).txnState(newState).topicPartitions(newTopicPartitions).txnStartTimestamp(newTxnStartTimestamp).txnLastUpdateTimestamp(updateTimestamp).build();
            if (log.isDebugEnabled()) {
                log.debug("TransactionalId {} prepare transition from {} to {}", new Object[]{this.transactionalId, this.state, txnTransitMetadata});
            }
            this.pendingState = Optional.of(newState);
            return txnTransitMetadata;
        }
        throw new IllegalStateException("Preparing transaction state transition to " + newState + "failed since the target state" + newState + "  is not a valid previous state of the current state " + this.state);
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        if (!this.pendingState.isPresent()) {
            throw new IllegalStateException("TransactionalId " + this.transactionalId + " completing transaction state transition while it does not have a pending state");
        }
        TransactionState toState = this.pendingState.get();
        if (toState != transitMetadata.txnState) {
            this.throwStateTransitionFailure(transitMetadata);
        } else {
            switch (toState) {
                case EMPTY: {
                    if (this.producerEpoch != transitMetadata.producerEpoch && !this.validProducerEpochBump(transitMetadata) || !transitMetadata.topicPartitions.isEmpty() || transitMetadata.txnStartTimestamp != -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                        break;
                    }
                    this.txnTimeoutMs = transitMetadata.txnTimeoutMs;
                    this.producerEpoch = transitMetadata.producerEpoch;
                    this.producerId = transitMetadata.producerId;
                    break;
                }
                case ONGOING: {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs != transitMetadata.txnTimeoutMs || this.txnStartTimestamp > transitMetadata.txnStartTimestamp) {
                        this.throwStateTransitionFailure(transitMetadata);
                        break;
                    }
                    this.txnStartTimestamp = transitMetadata.txnStartTimestamp;
                    this.topicPartitions.addAll(transitMetadata.topicPartitions);
                    break;
                }
                case PREPARE_ABORT: 
                case PREPARE_COMMIT: {
                    if (this.validProducerEpoch(transitMetadata) && this.topicPartitions.equals(transitMetadata.topicPartitions) && this.txnTimeoutMs == transitMetadata.txnTimeoutMs && this.txnStartTimestamp == transitMetadata.txnStartTimestamp) break;
                    this.throwStateTransitionFailure(transitMetadata);
                    break;
                }
                case COMPLETE_ABORT: 
                case COMPLETE_COMMIT: {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs != transitMetadata.txnTimeoutMs || transitMetadata.txnStartTimestamp == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                        break;
                    }
                    this.txnStartTimestamp = transitMetadata.txnStartTimestamp;
                    this.topicPartitions.clear();
                    break;
                }
                case PREPARE_EPOCH_FENCE: {
                    this.throwStateTransitionFailure(transitMetadata);
                    break;
                }
                case DEAD: {
                    throw new IllegalStateException("TransactionalId " + this.transactionalId + "is trying to complete a transition to " + toState + ". This means that the transactionalId was being expired, and the only acceptable completion of this operation is to remove the transaction metadata from the cache, not to persist the " + toState + "in the");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("TransactionalId {} complete transition from {} to {}", new Object[]{this.transactionalId, this.state, transitMetadata});
            }
            this.txnLastUpdateTimestamp = transitMetadata.txnLastUpdateTimestamp;
            this.pendingState = Optional.empty();
            this.state = toState;
        }
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch;
        long transitProducerId = transitMetadata.producerId;
        return transitEpoch == this.producerEpoch && transitProducerId == this.producerId;
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch;
        long transitProducerId = transitMetadata.producerId;
        return transitEpoch == this.producerEpoch + 1 || transitEpoch == 0 && transitProducerId != this.producerId;
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId, this.lastProducerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, this.state, this.topicPartitions, this.txnStartTimestamp, this.txnLastUpdateTimestamp);
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MAX_VALUE since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence ? this.producerEpoch : (short)(this.producerEpoch + 1);
        return this.prepareTransitionTo(TransactionState.PREPARE_EPOCH_FENCE, this.producerId, bumpedEpoch, (short)-1, this.txnTimeoutMs, this.topicPartitions, this.txnStartTimestamp, this.txnLastUpdateTimestamp);
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(Integer newTxnTimeoutMs, Optional<Short> expectedProducerEpoch, Long updateTimestamp) {
        Either<Object, BumpEpochResult> errorsOrBumpEpochResult;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException("Cannot allocate any more producer epochs for producerId $producerId");
        }
        short bumpedEpoch = (short)(this.producerEpoch + 1);
        if (!expectedProducerEpoch.isPresent()) {
            errorsOrBumpEpochResult = Either.right(new BumpEpochResult(bumpedEpoch, -1));
        } else if (this.producerEpoch == -1 || expectedProducerEpoch.get() == this.producerEpoch) {
            errorsOrBumpEpochResult = Either.right(new BumpEpochResult(bumpedEpoch, this.producerEpoch));
        } else if (expectedProducerEpoch.get() == this.lastProducerEpoch) {
            errorsOrBumpEpochResult = Either.right(new BumpEpochResult(this.producerEpoch, this.lastProducerEpoch));
        } else {
            log.info("Expected producer epoch {} does not match current producer epoch {} or previous producer epoch {}", new Object[]{expectedProducerEpoch, this.producerEpoch, this.lastProducerEpoch});
            errorsOrBumpEpochResult = Either.left(Errors.PRODUCER_FENCED);
        }
        return errorsOrBumpEpochResult.map(bumpEpochResult -> this.prepareTransitionTo(TransactionState.EMPTY, this.producerId, bumpEpochResult.bumpedEpoch, bumpEpochResult.lastEpoch, newTxnTimeoutMs, Collections.emptySet(), -1L, updateTimestamp));
    }

    public TxnTransitMetadata prepareProducerIdRotation(Long newProducerId, Integer newTxnTimeoutMs, Long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(TransactionState.EMPTY, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch : (short)-1, newTxnTimeoutMs, Collections.emptySet(), -1L, updateTimestamp);
    }

    private boolean hasPendingTransaction() {
        boolean flag = false;
        switch (this.state) {
            case ONGOING: 
            case PREPARE_ABORT: 
            case PREPARE_COMMIT: {
                flag = true;
                break;
            }
        }
        return flag;
    }

    public TxnTransitMetadata prepareAddPartitions(Set<TopicPartition> addedTopicPartitions, Long updateTimestamp) {
        long newTxnStartTimestamp = switch (this.state) {
            case TransactionState.EMPTY, TransactionState.COMPLETE_ABORT, TransactionState.COMPLETE_COMMIT -> updateTimestamp;
            default -> this.txnStartTimestamp;
        };
        HashSet<TopicPartition> newPartitionSet = new HashSet<TopicPartition>();
        if (this.topicPartitions != null) {
            newPartitionSet.addAll(this.topicPartitions);
        }
        newPartitionSet.addAll(new HashSet<TopicPartition>(addedTopicPartitions));
        return this.prepareTransitionTo(TransactionState.ONGOING, this.producerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, newPartitionSet, newTxnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, Long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, this.topicPartitions, this.txnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(Long updateTimestamp) {
        TransactionState newState = this.state == TransactionState.PREPARE_COMMIT ? TransactionState.COMPLETE_COMMIT : TransactionState.COMPLETE_ABORT;
        this.hasFailedEpochFence = false;
        return this.prepareTransitionTo(newState, this.producerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, Collections.emptySet(), this.txnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(TransactionState.DEAD, this.producerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, Collections.emptySet(), this.txnStartTimestamp, this.txnLastUpdateTimestamp);
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) throws IllegalStateException {
        log.error("{} transition to {} failed: this should not happen.", (Object)this, (Object)txnTransitMetadata);
        throw new IllegalStateException("TransactionalId " + this.transactionalId + " failed transition to state " + txnTransitMetadata + " due to unexpected metadata");
    }

    public boolean isProducerEpochExhausted() {
        return this.isEpochExhausted(this.producerEpoch);
    }

    public boolean isEpochExhausted(short producerEpoch) {
        return producerEpoch >= 32766;
    }

    public void removePartition(TopicPartition topicPartition) {
        if (this.state != TransactionState.PREPARE_COMMIT && this.state != TransactionState.PREPARE_ABORT) {
            throw new IllegalStateException(String.format("Transaction metadata's current state is %s, and its pending state is %s while trying to remove partitions whose txn marker has been sent, this is not expected", new Object[]{this.state, this.pendingState}));
        }
        this.topicPartitions.remove(topicPartition);
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions.addAll(partitions);
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState.isPresent();
    }

    private static Optional<TransactionState> $default$pendingState() {
        return Optional.empty();
    }

    public static TransactionMetadataBuilder builder() {
        return new TransactionMetadataBuilder();
    }

    public String getTransactionalId() {
        return this.transactionalId;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public long getLastProducerId() {
        return this.lastProducerId;
    }

    public short getProducerEpoch() {
        return this.producerEpoch;
    }

    public short getLastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public int getTxnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public TransactionState getState() {
        return this.state;
    }

    public Set<TopicPartition> getTopicPartitions() {
        return this.topicPartitions;
    }

    public long getTxnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public long getTxnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public Optional<TransactionState> getPendingState() {
        return this.pendingState;
    }

    public boolean isHasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public void setTransactionalId(String transactionalId) {
        this.transactionalId = transactionalId;
    }

    public void setProducerId(long producerId) {
        this.producerId = producerId;
    }

    public void setLastProducerId(long lastProducerId) {
        this.lastProducerId = lastProducerId;
    }

    public void setProducerEpoch(short producerEpoch) {
        this.producerEpoch = producerEpoch;
    }

    public void setLastProducerEpoch(short lastProducerEpoch) {
        this.lastProducerEpoch = lastProducerEpoch;
    }

    public void setTxnTimeoutMs(int txnTimeoutMs) {
        this.txnTimeoutMs = txnTimeoutMs;
    }

    public void setState(TransactionState state) {
        this.state = state;
    }

    public void setTopicPartitions(Set<TopicPartition> topicPartitions) {
        this.topicPartitions = topicPartitions;
    }

    public void setTxnStartTimestamp(long txnStartTimestamp) {
        this.txnStartTimestamp = txnStartTimestamp;
    }

    public void setTxnLastUpdateTimestamp(long txnLastUpdateTimestamp) {
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
    }

    public void setPendingState(Optional<TransactionState> pendingState) {
        this.pendingState = pendingState;
    }

    public void setHasFailedEpochFence(boolean hasFailedEpochFence) {
        this.hasFailedEpochFence = hasFailedEpochFence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMetadata)) {
            return false;
        }
        TransactionMetadata other = (TransactionMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProducerId() != other.getProducerId()) {
            return false;
        }
        if (this.getLastProducerId() != other.getLastProducerId()) {
            return false;
        }
        if (this.getProducerEpoch() != other.getProducerEpoch()) {
            return false;
        }
        if (this.getLastProducerEpoch() != other.getLastProducerEpoch()) {
            return false;
        }
        if (this.getTxnTimeoutMs() != other.getTxnTimeoutMs()) {
            return false;
        }
        if (this.getTxnStartTimestamp() != other.getTxnStartTimestamp()) {
            return false;
        }
        if (this.getTxnLastUpdateTimestamp() != other.getTxnLastUpdateTimestamp()) {
            return false;
        }
        if (this.isHasFailedEpochFence() != other.isHasFailedEpochFence()) {
            return false;
        }
        String this$transactionalId = this.getTransactionalId();
        String other$transactionalId = other.getTransactionalId();
        if (this$transactionalId == null ? other$transactionalId != null : !this$transactionalId.equals(other$transactionalId)) {
            return false;
        }
        TransactionState this$state = this.getState();
        TransactionState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Set<TopicPartition> this$topicPartitions = this.getTopicPartitions();
        Set<TopicPartition> other$topicPartitions = other.getTopicPartitions();
        if (this$topicPartitions == null ? other$topicPartitions != null : !((Object)this$topicPartitions).equals(other$topicPartitions)) {
            return false;
        }
        Optional<TransactionState> this$pendingState = this.getPendingState();
        Optional<TransactionState> other$pendingState = other.getPendingState();
        if (this$pendingState == null ? other$pendingState != null : !((Object)this$pendingState).equals(other$pendingState)) {
            return false;
        }
        ReentrantLock this$lock = this.getLock();
        ReentrantLock other$lock = other.getLock();
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $producerId = this.getProducerId();
        result = result * 59 + (int)($producerId >>> 32 ^ $producerId);
        long $lastProducerId = this.getLastProducerId();
        result = result * 59 + (int)($lastProducerId >>> 32 ^ $lastProducerId);
        result = result * 59 + this.getProducerEpoch();
        result = result * 59 + this.getLastProducerEpoch();
        result = result * 59 + this.getTxnTimeoutMs();
        long $txnStartTimestamp = this.getTxnStartTimestamp();
        result = result * 59 + (int)($txnStartTimestamp >>> 32 ^ $txnStartTimestamp);
        long $txnLastUpdateTimestamp = this.getTxnLastUpdateTimestamp();
        result = result * 59 + (int)($txnLastUpdateTimestamp >>> 32 ^ $txnLastUpdateTimestamp);
        result = result * 59 + (this.isHasFailedEpochFence() ? 79 : 97);
        String $transactionalId = this.getTransactionalId();
        result = result * 59 + ($transactionalId == null ? 43 : $transactionalId.hashCode());
        TransactionState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Set<TopicPartition> $topicPartitions = this.getTopicPartitions();
        result = result * 59 + ($topicPartitions == null ? 43 : ((Object)$topicPartitions).hashCode());
        Optional<TransactionState> $pendingState = this.getPendingState();
        result = result * 59 + ($pendingState == null ? 43 : ((Object)$pendingState).hashCode());
        ReentrantLock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionMetadata(transactionalId=" + this.getTransactionalId() + ", producerId=" + this.getProducerId() + ", lastProducerId=" + this.getLastProducerId() + ", producerEpoch=" + this.getProducerEpoch() + ", lastProducerEpoch=" + this.getLastProducerEpoch() + ", txnTimeoutMs=" + this.getTxnTimeoutMs() + ", state=" + this.getState() + ", topicPartitions=" + this.getTopicPartitions() + ", txnStartTimestamp=" + this.getTxnStartTimestamp() + ", txnLastUpdateTimestamp=" + this.getTxnLastUpdateTimestamp() + ", pendingState=" + this.getPendingState() + ", hasFailedEpochFence=" + this.isHasFailedEpochFence() + ", lock=" + this.getLock() + ")";
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, Optional<TransactionState> pendingState, boolean hasFailedEpochFence) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.pendingState = pendingState;
        this.hasFailedEpochFence = hasFailedEpochFence;
    }

    static {
        validPreviousStates.put(TransactionState.EMPTY, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.EMPTY, (Enum[])new TransactionState[]{TransactionState.COMPLETE_COMMIT, TransactionState.COMPLETE_ABORT}));
        validPreviousStates.put(TransactionState.ONGOING, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.ONGOING, (Enum[])new TransactionState[]{TransactionState.EMPTY, TransactionState.COMPLETE_COMMIT, TransactionState.COMPLETE_ABORT}));
        validPreviousStates.put(TransactionState.PREPARE_COMMIT, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.ONGOING, (Enum[])new TransactionState[0]));
        validPreviousStates.put(TransactionState.PREPARE_ABORT, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.ONGOING, (Enum[])new TransactionState[]{TransactionState.PREPARE_EPOCH_FENCE}));
        validPreviousStates.put(TransactionState.COMPLETE_COMMIT, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.PREPARE_COMMIT, (Enum[])new TransactionState[0]));
        validPreviousStates.put(TransactionState.COMPLETE_ABORT, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.PREPARE_ABORT, (Enum[])new TransactionState[0]));
        validPreviousStates.put(TransactionState.DEAD, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.EMPTY, (Enum[])new TransactionState[]{TransactionState.COMPLETE_COMMIT, TransactionState.COMPLETE_ABORT}));
        validPreviousStates.put(TransactionState.PREPARE_EPOCH_FENCE, (Set<TransactionState>)Sets.immutableEnumSet((Enum)TransactionState.ONGOING, (Enum[])new TransactionState[0]));
    }

    public static class TxnTransitMetadata {
        private long producerId;
        private long lastProducerId;
        private short producerEpoch;
        private short lastProducerEpoch;
        private int txnTimeoutMs;
        private TransactionState txnState;
        private Set<TopicPartition> topicPartitions;
        private long txnStartTimestamp;
        private long txnLastUpdateTimestamp;

        public static TxnTransitMetadataBuilder builder() {
            return new TxnTransitMetadataBuilder();
        }

        public String toString() {
            return "TransactionMetadata.TxnTransitMetadata(producerId=" + this.getProducerId() + ", lastProducerId=" + this.getLastProducerId() + ", producerEpoch=" + this.getProducerEpoch() + ", lastProducerEpoch=" + this.getLastProducerEpoch() + ", txnTimeoutMs=" + this.getTxnTimeoutMs() + ", txnState=" + this.getTxnState() + ", topicPartitions=" + this.getTopicPartitions() + ", txnStartTimestamp=" + this.getTxnStartTimestamp() + ", txnLastUpdateTimestamp=" + this.getTxnLastUpdateTimestamp() + ")";
        }

        public TxnTransitMetadata(long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState txnState, Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
            this.producerId = producerId;
            this.lastProducerId = lastProducerId;
            this.producerEpoch = producerEpoch;
            this.lastProducerEpoch = lastProducerEpoch;
            this.txnTimeoutMs = txnTimeoutMs;
            this.txnState = txnState;
            this.topicPartitions = topicPartitions;
            this.txnStartTimestamp = txnStartTimestamp;
            this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        }

        public long getProducerId() {
            return this.producerId;
        }

        public long getLastProducerId() {
            return this.lastProducerId;
        }

        public short getProducerEpoch() {
            return this.producerEpoch;
        }

        public short getLastProducerEpoch() {
            return this.lastProducerEpoch;
        }

        public int getTxnTimeoutMs() {
            return this.txnTimeoutMs;
        }

        public TransactionState getTxnState() {
            return this.txnState;
        }

        public Set<TopicPartition> getTopicPartitions() {
            return this.topicPartitions;
        }

        public long getTxnStartTimestamp() {
            return this.txnStartTimestamp;
        }

        public long getTxnLastUpdateTimestamp() {
            return this.txnLastUpdateTimestamp;
        }

        public void setProducerId(long producerId) {
            this.producerId = producerId;
        }

        public void setLastProducerId(long lastProducerId) {
            this.lastProducerId = lastProducerId;
        }

        public void setProducerEpoch(short producerEpoch) {
            this.producerEpoch = producerEpoch;
        }

        public void setLastProducerEpoch(short lastProducerEpoch) {
            this.lastProducerEpoch = lastProducerEpoch;
        }

        public void setTxnTimeoutMs(int txnTimeoutMs) {
            this.txnTimeoutMs = txnTimeoutMs;
        }

        public void setTxnState(TransactionState txnState) {
            this.txnState = txnState;
        }

        public void setTopicPartitions(Set<TopicPartition> topicPartitions) {
            this.topicPartitions = topicPartitions;
        }

        public void setTxnStartTimestamp(long txnStartTimestamp) {
            this.txnStartTimestamp = txnStartTimestamp;
        }

        public void setTxnLastUpdateTimestamp(long txnLastUpdateTimestamp) {
            this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TxnTransitMetadata)) {
                return false;
            }
            TxnTransitMetadata other = (TxnTransitMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProducerId() != other.getProducerId()) {
                return false;
            }
            if (this.getLastProducerId() != other.getLastProducerId()) {
                return false;
            }
            if (this.getProducerEpoch() != other.getProducerEpoch()) {
                return false;
            }
            if (this.getLastProducerEpoch() != other.getLastProducerEpoch()) {
                return false;
            }
            if (this.getTxnTimeoutMs() != other.getTxnTimeoutMs()) {
                return false;
            }
            if (this.getTxnStartTimestamp() != other.getTxnStartTimestamp()) {
                return false;
            }
            if (this.getTxnLastUpdateTimestamp() != other.getTxnLastUpdateTimestamp()) {
                return false;
            }
            TransactionState this$txnState = this.getTxnState();
            TransactionState other$txnState = other.getTxnState();
            if (this$txnState == null ? other$txnState != null : !((Object)((Object)this$txnState)).equals((Object)other$txnState)) {
                return false;
            }
            Set<TopicPartition> this$topicPartitions = this.getTopicPartitions();
            Set<TopicPartition> other$topicPartitions = other.getTopicPartitions();
            return !(this$topicPartitions == null ? other$topicPartitions != null : !((Object)this$topicPartitions).equals(other$topicPartitions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TxnTransitMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $producerId = this.getProducerId();
            result = result * 59 + (int)($producerId >>> 32 ^ $producerId);
            long $lastProducerId = this.getLastProducerId();
            result = result * 59 + (int)($lastProducerId >>> 32 ^ $lastProducerId);
            result = result * 59 + this.getProducerEpoch();
            result = result * 59 + this.getLastProducerEpoch();
            result = result * 59 + this.getTxnTimeoutMs();
            long $txnStartTimestamp = this.getTxnStartTimestamp();
            result = result * 59 + (int)($txnStartTimestamp >>> 32 ^ $txnStartTimestamp);
            long $txnLastUpdateTimestamp = this.getTxnLastUpdateTimestamp();
            result = result * 59 + (int)($txnLastUpdateTimestamp >>> 32 ^ $txnLastUpdateTimestamp);
            TransactionState $txnState = this.getTxnState();
            result = result * 59 + ($txnState == null ? 43 : ((Object)((Object)$txnState)).hashCode());
            Set<TopicPartition> $topicPartitions = this.getTopicPartitions();
            result = result * 59 + ($topicPartitions == null ? 43 : ((Object)$topicPartitions).hashCode());
            return result;
        }

        public static class TxnTransitMetadataBuilder {
            private long producerId;
            private long lastProducerId;
            private short producerEpoch;
            private short lastProducerEpoch;
            private int txnTimeoutMs;
            private TransactionState txnState;
            private Set<TopicPartition> topicPartitions;
            private long txnStartTimestamp;
            private long txnLastUpdateTimestamp;

            TxnTransitMetadataBuilder() {
            }

            public TxnTransitMetadataBuilder producerId(long producerId) {
                this.producerId = producerId;
                return this;
            }

            public TxnTransitMetadataBuilder lastProducerId(long lastProducerId) {
                this.lastProducerId = lastProducerId;
                return this;
            }

            public TxnTransitMetadataBuilder producerEpoch(short producerEpoch) {
                this.producerEpoch = producerEpoch;
                return this;
            }

            public TxnTransitMetadataBuilder lastProducerEpoch(short lastProducerEpoch) {
                this.lastProducerEpoch = lastProducerEpoch;
                return this;
            }

            public TxnTransitMetadataBuilder txnTimeoutMs(int txnTimeoutMs) {
                this.txnTimeoutMs = txnTimeoutMs;
                return this;
            }

            public TxnTransitMetadataBuilder txnState(TransactionState txnState) {
                this.txnState = txnState;
                return this;
            }

            public TxnTransitMetadataBuilder topicPartitions(Set<TopicPartition> topicPartitions) {
                this.topicPartitions = topicPartitions;
                return this;
            }

            public TxnTransitMetadataBuilder txnStartTimestamp(long txnStartTimestamp) {
                this.txnStartTimestamp = txnStartTimestamp;
                return this;
            }

            public TxnTransitMetadataBuilder txnLastUpdateTimestamp(long txnLastUpdateTimestamp) {
                this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
                return this;
            }

            public TxnTransitMetadata build() {
                return new TxnTransitMetadata(this.producerId, this.lastProducerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, this.txnState, this.topicPartitions, this.txnStartTimestamp, this.txnLastUpdateTimestamp);
            }

            public String toString() {
                return "TransactionMetadata.TxnTransitMetadata.TxnTransitMetadataBuilder(producerId=" + this.producerId + ", lastProducerId=" + this.lastProducerId + ", producerEpoch=" + this.producerEpoch + ", lastProducerEpoch=" + this.lastProducerEpoch + ", txnTimeoutMs=" + this.txnTimeoutMs + ", txnState=" + this.txnState + ", topicPartitions=" + this.topicPartitions + ", txnStartTimestamp=" + this.txnStartTimestamp + ", txnLastUpdateTimestamp=" + this.txnLastUpdateTimestamp + ")";
            }
        }
    }

    private static class BumpEpochResult {
        private final short bumpedEpoch;
        private final short lastEpoch;

        public BumpEpochResult(short bumpedEpoch, short lastEpoch) {
            this.bumpedEpoch = bumpedEpoch;
            this.lastEpoch = lastEpoch;
        }
    }

    public static class TransactionMetadataBuilder {
        private String transactionalId;
        private long producerId;
        private long lastProducerId;
        private short producerEpoch;
        private short lastProducerEpoch;
        private int txnTimeoutMs;
        private TransactionState state;
        private Set<TopicPartition> topicPartitions;
        private long txnStartTimestamp;
        private long txnLastUpdateTimestamp;
        private boolean pendingState$set;
        private Optional<TransactionState> pendingState$value;
        private boolean hasFailedEpochFence;

        TransactionMetadataBuilder() {
        }

        public TransactionMetadataBuilder transactionalId(String transactionalId) {
            this.transactionalId = transactionalId;
            return this;
        }

        public TransactionMetadataBuilder producerId(long producerId) {
            this.producerId = producerId;
            return this;
        }

        public TransactionMetadataBuilder lastProducerId(long lastProducerId) {
            this.lastProducerId = lastProducerId;
            return this;
        }

        public TransactionMetadataBuilder producerEpoch(short producerEpoch) {
            this.producerEpoch = producerEpoch;
            return this;
        }

        public TransactionMetadataBuilder lastProducerEpoch(short lastProducerEpoch) {
            this.lastProducerEpoch = lastProducerEpoch;
            return this;
        }

        public TransactionMetadataBuilder txnTimeoutMs(int txnTimeoutMs) {
            this.txnTimeoutMs = txnTimeoutMs;
            return this;
        }

        public TransactionMetadataBuilder state(TransactionState state) {
            this.state = state;
            return this;
        }

        public TransactionMetadataBuilder topicPartitions(Set<TopicPartition> topicPartitions) {
            this.topicPartitions = topicPartitions;
            return this;
        }

        public TransactionMetadataBuilder txnStartTimestamp(long txnStartTimestamp) {
            this.txnStartTimestamp = txnStartTimestamp;
            return this;
        }

        public TransactionMetadataBuilder txnLastUpdateTimestamp(long txnLastUpdateTimestamp) {
            this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
            return this;
        }

        public TransactionMetadataBuilder pendingState(Optional<TransactionState> pendingState) {
            this.pendingState$value = pendingState;
            this.pendingState$set = true;
            return this;
        }

        public TransactionMetadataBuilder hasFailedEpochFence(boolean hasFailedEpochFence) {
            this.hasFailedEpochFence = hasFailedEpochFence;
            return this;
        }

        public TransactionMetadata build() {
            Optional<TransactionState> pendingState$value = this.pendingState$value;
            if (!this.pendingState$set) {
                pendingState$value = TransactionMetadata.$default$pendingState();
            }
            return new TransactionMetadata(this.transactionalId, this.producerId, this.lastProducerId, this.producerEpoch, this.lastProducerEpoch, this.txnTimeoutMs, this.state, this.topicPartitions, this.txnStartTimestamp, this.txnLastUpdateTimestamp, pendingState$value, this.hasFailedEpochFence);
        }

        public String toString() {
            return "TransactionMetadata.TransactionMetadataBuilder(transactionalId=" + this.transactionalId + ", producerId=" + this.producerId + ", lastProducerId=" + this.lastProducerId + ", producerEpoch=" + this.producerEpoch + ", lastProducerEpoch=" + this.lastProducerEpoch + ", txnTimeoutMs=" + this.txnTimeoutMs + ", state=" + this.state + ", topicPartitions=" + this.topicPartitions + ", txnStartTimestamp=" + this.txnStartTimestamp + ", txnLastUpdateTimestamp=" + this.txnLastUpdateTimestamp + ", pendingState$value=" + this.pendingState$value + ", hasFailedEpochFence=" + this.hasFailedEpochFence + ")";
        }
    }
}

