/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.coordinator.transaction;

public enum TransactionState {
    EMPTY(0),
    ONGOING(1),
    PREPARE_COMMIT(2),
    PREPARE_ABORT(3),
    COMPLETE_COMMIT(4),
    COMPLETE_ABORT(5),
    DEAD(6),
    PREPARE_EPOCH_FENCE(7);

    private final byte value;

    private TransactionState(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static TransactionState byteToState(byte value) {
        switch (value) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return ONGOING;
            }
            case 2: {
                return PREPARE_COMMIT;
            }
            case 3: {
                return PREPARE_ABORT;
            }
            case 4: {
                return COMPLETE_COMMIT;
            }
            case 5: {
                return COMPLETE_ABORT;
            }
            case 6: {
                return DEAD;
            }
            case 7: {
                return PREPARE_EPOCH_FENCE;
            }
        }
        throw new IllegalStateException("Unknown transaction state byte " + value + " from the transaction status message");
    }

    public boolean isExpirationAllowed() {
        switch (this) {
            case EMPTY: 
            case COMPLETE_COMMIT: 
            case COMPLETE_ABORT: {
                return true;
            }
        }
        return false;
    }
}

