/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.format;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.streamnative.pulsar.handlers.kop.RequestStats;
import io.streamnative.pulsar.handlers.kop.format.EntryFormatter;
import io.streamnative.pulsar.handlers.kop.stats.StatsLogger;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;

public class DecodeResult {
    private MemoryRecords records;
    private ByteBuf releasedByteBuf;
    private int conversionCount;
    private long conversionTimeNanos;
    private final Recycler.Handle<DecodeResult> recyclerHandle;
    private static final Recycler<DecodeResult> RECYCLER = new Recycler<DecodeResult>(){

        protected DecodeResult newObject(Recycler.Handle<DecodeResult> handle) {
            return new DecodeResult(handle);
        }
    };

    public static DecodeResult get(MemoryRecords records) {
        return DecodeResult.get(records, null, 0, 0L);
    }

    public static DecodeResult get(MemoryRecords records, ByteBuf releasedByteBuf, int conversionCount, long conversionTimeNanos) {
        DecodeResult decodeResult = (DecodeResult)RECYCLER.get();
        decodeResult.records = records;
        decodeResult.releasedByteBuf = releasedByteBuf;
        decodeResult.conversionCount = conversionCount;
        decodeResult.conversionTimeNanos = conversionTimeNanos;
        return decodeResult;
    }

    private DecodeResult(Recycler.Handle<DecodeResult> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.records = null;
        if (this.releasedByteBuf != null) {
            this.releasedByteBuf.release();
            this.releasedByteBuf = null;
        }
        this.conversionCount = -1;
        this.conversionTimeNanos = -1L;
        this.recyclerHandle.recycle((Object)this);
    }

    @NonNull
    public ByteBuf getOrCreateByteBuf() {
        if (this.releasedByteBuf != null) {
            return this.releasedByteBuf;
        }
        return Unpooled.wrappedBuffer((ByteBuffer)this.records.buffer());
    }

    public void updateConsumerStats(TopicPartition topicPartition, int entrySize, String groupId, RequestStats statsLogger) {
        int numMessages = EntryFormatter.parseNumMessages(this.records);
        StatsLogger statsLoggerForThisPartition = statsLogger.getStatsLoggerForTopicPartition(topicPartition);
        statsLoggerForThisPartition.getCounter("CONSUME_MESSAGE_CONVERSIONS").add((long)this.conversionCount);
        statsLoggerForThisPartition.getOpStatsLogger("CONSUME_MESSAGE_CONVERSIONS_TIME_NANOS").registerSuccessfulEvent(this.conversionTimeNanos, TimeUnit.NANOSECONDS);
        StatsLogger statsLoggerForThisGroup = groupId != null ? statsLogger.getStatsLoggerForTopicPartitionAndGroup(topicPartition, groupId) : statsLoggerForThisPartition;
        statsLoggerForThisGroup.getCounter("BYTES_OUT").add((long)this.records.sizeInBytes());
        statsLoggerForThisGroup.getCounter("MESSAGE_OUT").add((long)numMessages);
        statsLoggerForThisGroup.getCounter("ENTRIES_OUT").add((long)entrySize);
    }

    public MemoryRecords getRecords() {
        return this.records;
    }

    public int getConversionCount() {
        return this.conversionCount;
    }

    public long getConversionTimeNanos() {
        return this.conversionTimeNanos;
    }
}

