/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.format;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;

public class DirectBufferOutputStream
extends ByteBufferOutputStream {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final ByteBufAllocator ALLOCATOR = PulsarByteBufAllocator.DEFAULT;
    private final int initialCapacity;
    private final ByteBuf byteBuf;

    public DirectBufferOutputStream(int initialCapacity) {
        super(EMPTY_BUFFER);
        this.initialCapacity = initialCapacity;
        this.byteBuf = ALLOCATOR.directBuffer(initialCapacity);
    }

    public void write(int b) {
        this.byteBuf.writeByte(b);
    }

    public void write(byte[] bytes, int off, int len) {
        this.byteBuf.writeBytes(bytes, off, len);
    }

    public void write(ByteBuffer sourceBuffer) {
        this.byteBuf.writeBytes(sourceBuffer);
    }

    public ByteBuffer buffer() {
        ByteBuffer byteBuffer = this.byteBuf.nioBuffer();
        byteBuffer.position(byteBuffer.limit());
        return byteBuffer;
    }

    public int position() {
        return this.byteBuf.readerIndex();
    }

    public void position(int position) {
        if (position > this.byteBuf.capacity()) {
            this.byteBuf.capacity(position);
        }
        this.byteBuf.writerIndex(position);
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }
}

