/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.format;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.streamnative.pulsar.handlers.kop.RequestStats;
import io.streamnative.pulsar.handlers.kop.stats.StatsLogger;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.pulsar.broker.service.Producer;

public class EncodeResult {
    private MemoryRecords records;
    private ByteBuf encodedByteBuf;
    private int numMessages;
    private int conversionCount;
    private long conversionTimeNanos;
    private final Recycler.Handle<EncodeResult> recyclerHandle;
    private static final Recycler<EncodeResult> RECYCLER = new Recycler<EncodeResult>(){

        protected EncodeResult newObject(Recycler.Handle<EncodeResult> handle) {
            return new EncodeResult(handle);
        }
    };

    public static EncodeResult get(MemoryRecords records, ByteBuf encodedByteBuf, int numMessages, int conversionCount, long conversionTimeNanos) {
        EncodeResult encodeResult = (EncodeResult)RECYCLER.get();
        encodeResult.records = records;
        encodeResult.encodedByteBuf = encodedByteBuf;
        encodeResult.numMessages = numMessages;
        encodeResult.conversionCount = conversionCount;
        encodeResult.conversionTimeNanos = conversionTimeNanos;
        return encodeResult;
    }

    private EncodeResult(Recycler.Handle<EncodeResult> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.records = null;
        if (this.encodedByteBuf != null) {
            this.encodedByteBuf.release();
            this.encodedByteBuf = null;
        }
        this.numMessages = -1;
        this.conversionCount = -1;
        this.conversionTimeNanos = -1L;
        this.recyclerHandle.recycle((Object)this);
    }

    public void updateProducerStats(TopicPartition topicPartition, RequestStats requestStats, Producer producer) {
        int numBytes = this.encodedByteBuf.readableBytes();
        producer.updateRates(this.numMessages, (long)numBytes);
        producer.getTopic().incrementPublishCount(this.numMessages, (long)numBytes);
        StatsLogger statsLoggerForThisPartition = requestStats.getStatsLoggerForTopicPartition(topicPartition);
        statsLoggerForThisPartition.getCounter("BYTES_IN").add((long)numBytes);
        statsLoggerForThisPartition.getCounter("MESSAGE_IN").add((long)this.numMessages);
        statsLoggerForThisPartition.getCounter("PRODUCE_MESSAGE_CONVERSIONS").add((long)this.conversionCount);
        statsLoggerForThisPartition.getOpStatsLogger("PRODUCE_MESSAGE_CONVERSIONS_TIME_NANOS").registerSuccessfulEvent(this.conversionTimeNanos, TimeUnit.NANOSECONDS);
        RequestStats.BATCH_COUNT_PER_MEMORY_RECORDS_INSTANCE.set(this.numMessages);
    }

    public MemoryRecords getRecords() {
        return this.records;
    }

    public ByteBuf getEncodedByteBuf() {
        return this.encodedByteBuf;
    }

    public int getNumMessages() {
        return this.numMessages;
    }

    public int getConversionCount() {
        return this.conversionCount;
    }

    public long getConversionTimeNanos() {
        return this.conversionTimeNanos;
    }

    public Recycler.Handle<EncodeResult> getRecyclerHandle() {
        return this.recyclerHandle;
    }
}

