/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.format;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import io.streamnative.pulsar.handlers.kop.format.EntryFormatter;
import io.streamnative.pulsar.handlers.kop.format.KafkaMixedEntryFormatter;
import io.streamnative.pulsar.handlers.kop.format.KafkaV1EntryFormatter;
import io.streamnative.pulsar.handlers.kop.format.PulsarEntryFormatter;
import org.apache.pulsar.broker.service.plugin.EntryFilterWithClassLoader;

public class EntryFormatterFactory {
    public static EntryFormatter create(KafkaServiceConfiguration kafkaConfig, ImmutableMap<String, EntryFilterWithClassLoader> entryfilterMap, String format) {
        try {
            EntryFormat entryFormat = Enum.valueOf(EntryFormat.class, format.toUpperCase());
            ImmutableList entryfilters = entryfilterMap == null ? ImmutableList.of() : entryfilterMap.values().asList();
            switch (entryFormat) {
                case PULSAR: {
                    return new PulsarEntryFormatter((ImmutableList<EntryFilterWithClassLoader>)entryfilters);
                }
                case KAFKA: {
                    return new KafkaV1EntryFormatter((ImmutableList<EntryFilterWithClassLoader>)entryfilters);
                }
                case MIXED_KAFKA: {
                    return new KafkaMixedEntryFormatter((ImmutableList<EntryFilterWithClassLoader>)entryfilters);
                }
            }
            throw new Exception("No EntryFormatter for " + entryFormat);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported entry.format '" + format + "': " + e.getMessage());
        }
    }

    static enum EntryFormat {
        PULSAR,
        KAFKA,
        MIXED_KAFKA;

    }
}

