/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.format;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.streamnative.pulsar.handlers.kop.format.AbstractEntryFormatter;
import io.streamnative.pulsar.handlers.kop.format.DecodeResult;
import io.streamnative.pulsar.handlers.kop.format.EncodeRequest;
import io.streamnative.pulsar.handlers.kop.format.EncodeResult;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.pulsar.broker.service.plugin.EntryFilterWithClassLoader;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaV1EntryFormatter
extends AbstractEntryFormatter {
    private static final Logger log = LoggerFactory.getLogger(KafkaV1EntryFormatter.class);

    protected KafkaV1EntryFormatter(ImmutableList<EntryFilterWithClassLoader> entryfilters) {
        super(entryfilters);
    }

    @Override
    public EncodeResult encode(EncodeRequest encodeRequest) {
        MemoryRecords records = encodeRequest.getRecords();
        int numMessages = encodeRequest.getAppendInfo().numMessages();
        ByteBuf recordsWrapper = Unpooled.wrappedBuffer((ByteBuffer)records.buffer());
        ByteBuf buf = Commands.serializeMetadataAndPayload((Commands.ChecksumType)Commands.ChecksumType.None, (MessageMetadata)KafkaV1EntryFormatter.getMessageMetadataWithNumberMessages(numMessages), (ByteBuf)recordsWrapper);
        recordsWrapper.release();
        return EncodeResult.get(records, buf, numMessages, 0, 0L);
    }

    @Override
    public DecodeResult decode(List<Entry> entries, byte magic) {
        return super.decode(entries, magic);
    }

    private static MessageMetadata getMessageMetadataWithNumberMessages(int numMessages) {
        MessageMetadata metadata = new MessageMetadata();
        metadata.addProperty().setKey("entry.format").setValue(IDENTITY_VALUE);
        metadata.setProducerName("");
        metadata.setSequenceId(0L);
        metadata.setPublishTime(System.currentTimeMillis());
        metadata.setNumMessagesInBatch(numMessages);
        return metadata;
    }
}

