/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.streamnative.pulsar.handlers.kop.http.HttpHandler;
import java.util.function.Consumer;

public class HttpChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final int MAX_FRAME_LENGTH = 0x500000;
    private final HttpHandler httpHandler;
    private final Consumer<ChannelPipeline> pipelineCustomizer;

    public HttpChannelInitializer(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
        this.pipelineCustomizer = null;
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.pipelineCustomizer != null) {
            this.pipelineCustomizer.accept(p);
        }
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)});
        p.addLast(new ChannelHandler[]{this.httpHandler});
    }

    public HttpChannelInitializer(HttpHandler httpHandler, Consumer<ChannelPipeline> pipelineCustomizer) {
        this.httpHandler = httpHandler;
        this.pipelineCustomizer = pipelineCustomizer;
    }
}

