/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.streamnative.pulsar.handlers.kop.http.HttpRequestProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class HttpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpHandler.class);
    private final List<HttpRequestProcessor> processors = new ArrayList<HttpRequestProcessor>();

    public HttpHandler addProcessor(HttpRequestProcessor processor) {
        this.processors.add(processor);
        return this;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("{} at {} request {}", new Object[]{this.getName(), ctx.channel().localAddress(), request});
        }
        log.info("{} {} {} from {}", new Object[]{this.getName(), request.method(), request.uri(), ctx.channel().localAddress()});
        Optional<HttpRequestProcessor> processorOr = this.processors.stream().filter(p -> p.acceptRequest(request)).findAny();
        if (!processorOr.isPresent()) {
            FullHttpResponse notFoundResponse = this.getNotFoundResponse(request, ctx);
            ctx.writeAndFlush((Object)notFoundResponse);
            return;
        }
        HttpRequestProcessor processor = processorOr.get();
        CompletableFuture<FullHttpResponse> fullHttpResponse = processor.processRequest(request);
        ((CompletableFuture)fullHttpResponse.thenAccept(resp -> {
            if (log.isDebugEnabled()) {
                log.debug("{} at {} request {} response {}", new Object[]{this.getName(), ctx.channel().localAddress(), request, resp});
            }
            log.info("{} {} {} from {} response {} {}", new Object[]{this.getName(), request.method(), request.uri(), ctx.channel().localAddress(), resp.status().code(), resp.status().reasonPhrase()});
            ctx.writeAndFlush(resp);
        })).exceptionally(err -> {
            FullHttpResponse resp = processor.buildJsonErrorResponse((Throwable)err);
            if (log.isDebugEnabled()) {
                log.debug("{} at {} request {} response {}", new Object[]{this.getName(), ctx.channel().localAddress(), request, resp});
            }
            log.info("{} {} {} from {} response {} {}", new Object[]{this.getName(), request.method(), request.uri(), ctx.channel().localAddress(), resp.status().code(), resp.status().reasonPhrase()});
            ctx.writeAndFlush((Object)resp);
            return null;
        });
    }

    protected abstract FullHttpResponse getNotFoundResponse(FullHttpRequest var1, ChannelHandlerContext var2);

    protected abstract String getName();

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("Unhandled error, closing connection to {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }
}

