/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public abstract class HttpRequestProcessor
implements AutoCloseable {
    protected static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);

    public static FullHttpResponse buildStringResponse(String body, String contentType) {
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)body, (Charset)CharsetUtil.UTF_8));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length());
        HttpRequestProcessor.addCORSHeaders((FullHttpResponse)httpResponse);
        return httpResponse;
    }

    public static FullHttpResponse buildEmptyResponseNoContentResponse() {
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT, Unpooled.EMPTY_BUFFER);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ALLOW, (Object)"GET, POST, PUT, DELETE");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        HttpRequestProcessor.addCORSHeaders((FullHttpResponse)httpResponse);
        return httpResponse;
    }

    public static FullHttpResponse buildErrorResponse(HttpResponseStatus error, String body, String contentType) {
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, error, Unpooled.copiedBuffer((CharSequence)body, (Charset)CharsetUtil.UTF_8));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length());
        HttpRequestProcessor.addCORSHeaders((FullHttpResponse)httpResponse);
        return httpResponse;
    }

    protected abstract int statusCodeFromThrowable(Throwable var1);

    protected abstract String getErrorResponseContentType();

    public FullHttpResponse buildJsonErrorResponse(Throwable throwable) {
        String contentType;
        Object body;
        Throwable err = throwable;
        while (err instanceof CompletionException) {
            err = err.getCause();
        }
        int httpStatusCode = this.statusCodeFromThrowable(err);
        HttpResponseStatus error = HttpResponseStatus.valueOf((int)httpStatusCode);
        try {
            body = MAPPER.writeValueAsString((Object)new ErrorModel(httpStatusCode, err.getMessage()));
            contentType = this.getErrorResponseContentType();
        }
        catch (JsonProcessingException impossible) {
            body = "Error " + err;
            contentType = "text/plain";
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, error, Unpooled.copiedBuffer((CharSequence)body, (Charset)CharsetUtil.UTF_8));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)((String)body).length());
        HttpRequestProcessor.addCORSHeaders((FullHttpResponse)httpResponse);
        return httpResponse;
    }

    public static void addCORSHeaders(FullHttpResponse httpResponse) {
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)true);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)"PUT, POST, GET, DELETE");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"content-type");
    }

    protected abstract boolean acceptRequest(FullHttpRequest var1);

    protected abstract CompletableFuture<FullHttpResponse> processRequest(FullHttpRequest var1);

    @VisibleForTesting
    static FullHttpResponse buildJsonResponse(Object content, String contentType) {
        try {
            String body = MAPPER.writeValueAsString(content);
            return HttpRequestProcessor.buildStringResponse(body, contentType);
        }
        catch (JsonProcessingException err) {
            return HttpRequestProcessor.buildErrorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Internal server error - JSON Processing", "text/plain");
        }
    }

    @Override
    public void close() {
    }

    private static final class ErrorModel {
        final int errorCode;
        final String message;

        @JsonProperty(value="error_code")
        public int getErrorCode() {
            return this.errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public ErrorModel(int errorCode, String message) {
            this.errorCode = errorCode;
            this.message = message;
        }
    }
}

