/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.migration;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.streamnative.pulsar.handlers.kop.http.HttpHandler;
import io.streamnative.pulsar.handlers.kop.schemaregistry.HttpRequestProcessor;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MigrationHandler
extends HttpHandler {
    private static final Logger log = LoggerFactory.getLogger(MigrationHandler.class);

    @Override
    protected FullHttpResponse getNotFoundResponse(FullHttpRequest request, ChannelHandlerContext ctx) {
        String body = "{\n  \"message\" : \"Not found\",\n  \"error_code\" : 404\n}";
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((CharSequence)body, (Charset)CharsetUtil.UTF_8));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/vnd.schemaregistry.v1+json");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length());
        HttpRequestProcessor.addCORSHeaders((FullHttpResponse)httpResponse);
        log.info("not found {} {} from {}", new Object[]{request.method(), request.uri(), ctx.channel().localAddress()});
        if (log.isDebugEnabled()) {
            log.debug("SchemaRegistry at {} request {} response {}", new Object[]{ctx.channel().localAddress(), request, httpResponse});
        }
        return httpResponse;
    }

    @Override
    protected String getName() {
        return "MigrationHandler";
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("Unhandled error, closing connection to {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }
}

