/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.migration;

import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import io.streamnative.pulsar.handlers.kop.SystemTopicClient;
import io.streamnative.pulsar.handlers.kop.http.HttpChannelInitializer;
import io.streamnative.pulsar.handlers.kop.migration.MigrationHandler;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationManager {
    private static final Logger log = LoggerFactory.getLogger(MigrationManager.class);
    private final KafkaServiceConfiguration kafkaConfig;
    private final PulsarClient pulsarClient;

    public MigrationManager(KafkaServiceConfiguration kafkaConfig, PulsarService pulsar) {
        this.kafkaConfig = kafkaConfig;
        this.pulsarClient = SystemTopicClient.createPulsarClient(pulsar, kafkaConfig, ___ -> {});
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.kafkaConfig.getKopMigrationServicePort());
    }

    public Optional<HttpChannelInitializer> build() {
        if (!this.kafkaConfig.isKopMigrationEnable()) {
            return Optional.empty();
        }
        MigrationHandler handler = new MigrationHandler();
        return Optional.of(new HttpChannelInitializer(handler));
    }

    public void close() {
        try {
            this.pulsarClient.close();
        }
        catch (PulsarClientException err) {
            log.error("Error while shutting down", (Throwable)err);
        }
    }
}

