/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.offset;

import io.streamnative.pulsar.handlers.kop.offset.OffsetMetadata;

public class OffsetAndMetadata {
    public static final String NoMetadata = "";
    private final OffsetMetadata offsetMetadata;
    private final long commitTimestamp;
    private final long expireTimestamp;

    public static OffsetAndMetadata apply(long offset, String metadata, long commitTimestamp, long expireTimestamp) {
        return new OffsetAndMetadata(new OffsetMetadata(offset, metadata), commitTimestamp, expireTimestamp);
    }

    public static OffsetAndMetadata apply(long offset, String metadata, long timestamp) {
        return new OffsetAndMetadata(new OffsetMetadata(offset, metadata), timestamp, timestamp);
    }

    public static OffsetAndMetadata apply(long offset, String metadata) {
        return new OffsetAndMetadata(new OffsetMetadata(offset, metadata));
    }

    public static OffsetAndMetadata apply(long offset) {
        return new OffsetAndMetadata(new OffsetMetadata(offset, NoMetadata));
    }

    private OffsetAndMetadata(OffsetMetadata offsetMetadata) {
        this(offsetMetadata, -1L, -1L);
    }

    public long offset() {
        return this.offsetMetadata.offset();
    }

    public String metadata() {
        return this.offsetMetadata.metadata();
    }

    public String toString() {
        return String.format("[%s,CommitTime %d,ExpirationTime %d]", this.offsetMetadata, this.commitTimestamp, this.expireTimestamp);
    }

    public OffsetMetadata offsetMetadata() {
        return this.offsetMetadata;
    }

    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    public long expireTimestamp() {
        return this.expireTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OffsetAndMetadata)) {
            return false;
        }
        OffsetAndMetadata other = (OffsetAndMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.commitTimestamp() != other.commitTimestamp()) {
            return false;
        }
        if (this.expireTimestamp() != other.expireTimestamp()) {
            return false;
        }
        OffsetMetadata this$offsetMetadata = this.offsetMetadata();
        OffsetMetadata other$offsetMetadata = other.offsetMetadata();
        return !(this$offsetMetadata == null ? other$offsetMetadata != null : !((Object)this$offsetMetadata).equals(other$offsetMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OffsetAndMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $commitTimestamp = this.commitTimestamp();
        result = result * 59 + (int)($commitTimestamp >>> 32 ^ $commitTimestamp);
        long $expireTimestamp = this.expireTimestamp();
        result = result * 59 + (int)($expireTimestamp >>> 32 ^ $expireTimestamp);
        OffsetMetadata $offsetMetadata = this.offsetMetadata();
        result = result * 59 + ($offsetMetadata == null ? 43 : ((Object)$offsetMetadata).hashCode());
        return result;
    }

    private OffsetAndMetadata(OffsetMetadata offsetMetadata, long commitTimestamp, long expireTimestamp) {
        this.offsetMetadata = offsetMetadata;
        this.commitTimestamp = commitTimestamp;
        this.expireTimestamp = expireTimestamp;
    }
}

