/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.offset;

import io.streamnative.pulsar.handlers.kop.offset.OffsetMetadata;
import org.apache.kafka.common.protocol.Errors;

public class OffsetMetadataAndError {
    public static final OffsetMetadataAndError NO_OFFSET = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.NONE);
    public static final OffsetMetadataAndError GROUP_LOADING = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.COORDINATOR_LOAD_IN_PROGRESS);
    public static final OffsetMetadataAndError UNKNOWN_MEMBER = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.UNKNOWN_MEMBER_ID);
    public static final OffsetMetadataAndError NOT_COORDINATOR_FOR_GROUP = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.NOT_COORDINATOR);
    public static final OffsetMetadataAndError GROUP_COORDINATOR_NOT_AVAILABLE = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.COORDINATOR_NOT_AVAILABLE);
    public static final OffsetMetadataAndError UNKNOWN_TOPIC_OR_PARTITION = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    public static final OffsetMetadataAndError ILLEGAL_GROUP_GENERATION_ID = new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, Errors.ILLEGAL_GENERATION);
    private final OffsetMetadata offsetMetadata;
    private final Errors error;

    public static OffsetMetadataAndError apply(long offset) {
        return new OffsetMetadataAndError(new OffsetMetadata(offset, ""), Errors.NONE);
    }

    public static OffsetMetadataAndError apply(Errors errors) {
        return new OffsetMetadataAndError(OffsetMetadata.INVALID_OFFSET_METADATA, errors);
    }

    public static OffsetMetadataAndError apply(long offset, String metadata, Errors errors) {
        return new OffsetMetadataAndError(new OffsetMetadata(offset, metadata), errors);
    }

    private OffsetMetadataAndError(OffsetMetadata offsetMetadata) {
        this(offsetMetadata, Errors.NONE);
    }

    public long offset() {
        return this.offsetMetadata.offset();
    }

    public String metadata() {
        return this.offsetMetadata.metadata();
    }

    public String toString() {
        return String.format("[%s, Error=%s]", this.offsetMetadata, this.error);
    }

    public OffsetMetadata getOffsetMetadata() {
        return this.offsetMetadata;
    }

    public Errors getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OffsetMetadataAndError)) {
            return false;
        }
        OffsetMetadataAndError other = (OffsetMetadataAndError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OffsetMetadata this$offsetMetadata = this.getOffsetMetadata();
        OffsetMetadata other$offsetMetadata = other.getOffsetMetadata();
        if (this$offsetMetadata == null ? other$offsetMetadata != null : !((Object)this$offsetMetadata).equals(other$offsetMetadata)) {
            return false;
        }
        Errors this$error = this.getError();
        Errors other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OffsetMetadataAndError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OffsetMetadata $offsetMetadata = this.getOffsetMetadata();
        result = result * 59 + ($offsetMetadata == null ? 43 : ((Object)$offsetMetadata).hashCode());
        Errors $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    private OffsetMetadataAndError(OffsetMetadata offsetMetadata, Errors error) {
        this.offsetMetadata = offsetMetadata;
        this.error = error;
    }
}

