/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.scala;

import java.util.function.Consumer;
import java.util.function.Function;

public class Either<V, W> {
    private final V left;
    private final W right;

    public boolean isLeft() {
        return this.left != null;
    }

    public static <V, W> Either<V, W> left(V left) {
        return new Either<V, Object>(left, null);
    }

    public static <V, W> Either<V, W> right(W right) {
        return new Either<Object, W>(null, right);
    }

    public void match(Consumer<V> leftConsumer, Consumer<W> rightConsumer) {
        if (this.left == null) {
            rightConsumer.accept(this.right);
        } else {
            leftConsumer.accept(this.left);
        }
    }

    public <R> Either<V, R> map(Function<W, R> function) {
        if (this.left == null) {
            return Either.right(function.apply(this.right));
        }
        Either other = this;
        return other;
    }

    private Either(V left, W right) {
        this.left = left;
        this.right = right;
    }

    public V getLeft() {
        return this.left;
    }

    public W getRight() {
        return this.right;
    }
}

