/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security;

import io.streamnative.pulsar.handlers.kop.SaslAuth;
import io.streamnative.pulsar.handlers.kop.utils.SaslUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainSaslServer
implements SaslServer {
    private static final Logger log = LoggerFactory.getLogger(PlainSaslServer.class);
    public static final String PLAIN_MECHANISM = "PLAIN";
    private final AuthenticationService authenticationService;
    private final PulsarAdmin admin;
    private boolean complete;
    private String authorizationId;
    private String username;
    private AuthenticationDataSource authDataSource;
    private Set<String> proxyRoles;

    public PlainSaslServer(AuthenticationService authenticationService, PulsarAdmin admin, Set<String> proxyRoles) {
        this.authenticationService = authenticationService;
        this.admin = admin;
        this.proxyRoles = proxyRoles;
    }

    @Override
    public String getMechanismName() {
        return PLAIN_MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        SaslAuth saslAuth;
        try {
            saslAuth = SaslUtils.parseSaslAuthBytes(response);
        }
        catch (IOException e) {
            throw new SaslException(e.getMessage());
        }
        this.username = saslAuth.getUsername();
        AuthenticationProvider authenticationProvider = this.authenticationService.getAuthenticationProvider(saslAuth.getAuthMethod());
        if (authenticationProvider == null) {
            throw new SaslException("No AuthenticationProvider found for method " + saslAuth.getAuthMethod());
        }
        try {
            AuthenticationState authState = authenticationProvider.newAuthState(AuthData.of((byte[])saslAuth.getAuthData().getBytes(StandardCharsets.UTF_8)), null, null);
            String role = authState.getAuthRole();
            if (StringUtils.isEmpty((CharSequence)role)) {
                throw new AuthenticationException("Role cannot be empty.");
            }
            if (this.proxyRoles != null && this.proxyRoles.contains(authState.getAuthRole())) {
                this.authorizationId = saslAuth.getUsername();
                this.authDataSource = authState.getAuthDataSource();
                this.username = null;
                if (this.authorizationId.contains("/")) {
                    int lastSlash = this.authorizationId.lastIndexOf(47);
                    this.username = this.authorizationId.substring(lastSlash + 1);
                    this.authorizationId = this.authorizationId.substring(0, lastSlash);
                }
                log.info("Authenticated Proxy role {} as user role {} tenant (username) {}", new Object[]{authState.getAuthRole(), this.authorizationId, this.username});
                if (this.proxyRoles.contains(this.authorizationId)) {
                    throw new SaslException("The proxy (with role " + authState.getAuthRole() + ") tried to forward another proxy user (with role " + this.authorizationId + ")");
                }
            } else {
                this.authorizationId = authState.getAuthRole();
                this.authDataSource = authState.getAuthDataSource();
                log.info("Authenticated User {}, AuthDataSource {}", (Object)this.authorizationId, (Object)this.authDataSource);
            }
            this.complete = true;
            return new byte[0];
        }
        catch (AuthenticationException e) {
            throw new SaslException(e.getMessage());
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return this.authorizationId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        if ("username".equals(propName)) {
            return this.username;
        }
        if ("authDataSource".equals(propName)) {
            return this.authDataSource;
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

