/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security.auth;

import java.util.HashMap;
import java.util.Locale;

public enum ResourceType {
    UNKNOWN(0),
    TOPIC(1),
    NAMESPACE(2),
    TENANT(3);

    private final byte code;
    private static final HashMap<Byte, ResourceType> CODE_TO_VALUE;

    public static ResourceType fromString(String str) {
        try {
            return ResourceType.valueOf(str.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public static ResourceType fromCode(byte code) {
        ResourceType resourceType = CODE_TO_VALUE.get(code);
        if (resourceType == null) {
            return UNKNOWN;
        }
        return resourceType;
    }

    private ResourceType(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        CODE_TO_VALUE = new HashMap();
        for (ResourceType resourceType : ResourceType.values()) {
            CODE_TO_VALUE.put(resourceType.code, resourceType);
        }
    }
}

