/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security.auth;

import com.google.common.base.Preconditions;
import io.streamnative.pulsar.handlers.kop.security.KafkaPrincipal;
import io.streamnative.pulsar.handlers.kop.security.auth.Authorizer;
import io.streamnative.pulsar.handlers.kop.security.auth.Resource;
import io.streamnative.pulsar.handlers.kop.security.auth.ResourceType;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAclAuthorizer
implements Authorizer {
    private static final Logger log = LoggerFactory.getLogger(SimpleAclAuthorizer.class);
    private final PulsarService pulsarService;
    private final AuthorizationService authorizationService;

    public SimpleAclAuthorizer(PulsarService pulsarService) {
        this.pulsarService = pulsarService;
        this.authorizationService = pulsarService.getBrokerService().getAuthorizationService();
    }

    protected PulsarService getPulsarService() {
        return this.pulsarService;
    }

    private CompletableFuture<Boolean> authorizeTenantPermission(KafkaPrincipal principal, Resource resource) {
        CompletableFuture<Boolean> permissionFuture = new CompletableFuture<Boolean>();
        String tenant = resource.getName();
        ((CompletableFuture)this.getPulsarService().getPulsarResources().getTenantResources().getTenantAsync(tenant).thenAccept(tenantInfo -> permissionFuture.complete(tenantInfo.isPresent()))).exceptionally(ex -> {
            if (log.isDebugEnabled()) {
                log.debug("Client with Principal - {} failed to get permissions for resource - {}. {}", new Object[]{principal, resource, ex.getMessage()});
            }
            permissionFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return permissionFuture;
    }

    @Override
    public CompletableFuture<Boolean> canAccessTenantAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TENANT ? 1 : 0) != 0, (Object)String.format("Expected resource type is TENANT, but have [%s]", new Object[]{resource.getResourceType()}));
        CompletableFuture<Boolean> canAccessFuture = new CompletableFuture<Boolean>();
        this.authorizeTenantPermission(principal, resource).whenComplete((hasPermission, ex) -> {
            if (ex != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Resource [{}] Principal [{}] exception occurred while trying to check Tenant permissions. {}", new Object[]{resource, principal, ex.getMessage()});
                }
                canAccessFuture.completeExceptionally((Throwable)ex);
                return;
            }
            canAccessFuture.complete((Boolean)hasPermission);
        });
        return canAccessFuture;
    }

    @Override
    public CompletableFuture<Boolean> canCreateTopicAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.allowNamespaceOperationAsync(topicName.getNamespaceObject(), NamespaceOperation.CREATE_TOPIC, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canDeleteTopicAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.allowNamespaceOperationAsync(topicName.getNamespaceObject(), NamespaceOperation.DELETE_TOPIC, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canAlterTopicAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.allowTopicPolicyOperationAsync(topicName, PolicyName.PARTITION, PolicyOperation.WRITE, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canManageTenantAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canLookupAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.canLookupAsync(topicName, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canGetTopicList(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.NAMESPACE ? 1 : 0) != 0, (Object)String.format("Expected resource type is NAMESPACE, but have [%s]", new Object[]{resource.getResourceType()}));
        return this.authorizationService.allowNamespaceOperationAsync(NamespaceName.get((String)resource.getName()), NamespaceOperation.GET_TOPICS, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canProduceAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.canProduceAsync(topicName, principal.getName(), principal.getAuthenticationData());
    }

    @Override
    public CompletableFuture<Boolean> canConsumeAsync(KafkaPrincipal principal, Resource resource) {
        Preconditions.checkArgument((resource.getResourceType() == ResourceType.TOPIC ? 1 : 0) != 0, (Object)String.format("Expected resource type is TOPIC, but have [%s]", new Object[]{resource.getResourceType()}));
        TopicName topicName = TopicName.get((String)resource.getName());
        return this.authorizationService.canConsumeAsync(topicName, principal.getName(), principal.getAuthenticationData(), "");
    }
}

