/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security.oauth;

import io.streamnative.pulsar.handlers.kop.security.oauth.KopOAuthBearerToken;
import io.streamnative.pulsar.handlers.kop.security.oauth.KopOAuthBearerValidatorCallback;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KopOAuthBearerSaslServer
implements SaslServer {
    private static final Logger log = LoggerFactory.getLogger(KopOAuthBearerSaslServer.class);
    private static final byte BYTE_CONTROL_A = 1;
    private static final String NEGOTIATED_PROPERTY_KEY_TOKEN = "OAUTHBEARER.token";
    private static final String INTERNAL_ERROR_ON_SERVER = "Authentication could not be performed due to an internal error on the server";
    private final AuthenticateCallbackHandler callbackHandler;
    private final String defaultKafkaMetadataTenant;
    private boolean complete;
    private KopOAuthBearerToken tokenForNegotiatedProperty = null;
    private String errorMessage = null;

    public KopOAuthBearerSaslServer(CallbackHandler callbackHandler, String defaultKafkaMetadataTenant) {
        if (!(Objects.requireNonNull(callbackHandler) instanceof AuthenticateCallbackHandler)) {
            throw new IllegalArgumentException(String.format("Callback handler must be castable to %s: %s", AuthenticateCallbackHandler.class.getName(), callbackHandler.getClass().getName()));
        }
        this.callbackHandler = (AuthenticateCallbackHandler)callbackHandler;
        this.defaultKafkaMetadataTenant = defaultKafkaMetadataTenant;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException, SaslAuthenticationException {
        OAuthBearerClientInitialResponse clientResponse;
        if (response.length == 1 && response[0] == 1 && this.errorMessage != null) {
            if (log.isDebugEnabled()) {
                log.debug("Received %x01 response from client after it received our error");
            }
            throw new SaslAuthenticationException(this.errorMessage);
        }
        this.errorMessage = null;
        try {
            clientResponse = new OAuthBearerClientInitialResponse(response);
        }
        catch (SaslException e) {
            log.debug(e.getMessage());
            throw e;
        }
        return this.process(clientResponse.tokenValue(), clientResponse.authorizationId());
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return this.tokenForNegotiatedProperty.principalName();
    }

    @Override
    public String getMechanismName() {
        return "OAUTHBEARER";
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        if ("authDataSource".equals(propName)) {
            return this.tokenForNegotiatedProperty.authDataSource();
        }
        if ("username".equals(propName)) {
            if (this.tokenForNegotiatedProperty.tenant() != null) {
                return this.tokenForNegotiatedProperty.tenant();
            }
            return this.defaultKafkaMetadataTenant;
        }
        return NEGOTIATED_PROPERTY_KEY_TOKEN.equals(propName) ? this.tokenForNegotiatedProperty : null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public void dispose() throws SaslException {
        this.complete = false;
        this.tokenForNegotiatedProperty = null;
    }

    private byte[] process(String tokenValue, String authorizationId) throws SaslException {
        KopOAuthBearerValidatorCallback callback = new KopOAuthBearerValidatorCallback(tokenValue);
        try {
            this.callbackHandler.handle(new Callback[]{callback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            String msg = String.format("%s: %s", INTERNAL_ERROR_ON_SERVER, e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(msg, (Throwable)e);
            }
            throw new SaslException(msg);
        }
        KopOAuthBearerToken token = callback.token();
        if (token == null) {
            this.errorMessage = KopOAuthBearerSaslServer.jsonErrorResponse(callback.errorStatus(), callback.errorScope(), callback.errorOpenIDConfiguration());
            if (log.isDebugEnabled()) {
                log.debug(this.errorMessage);
            }
            return this.errorMessage.getBytes(StandardCharsets.UTF_8);
        }
        if (!authorizationId.isEmpty() && !authorizationId.equals(token.principalName())) {
            throw new SaslAuthenticationException(String.format("Authentication failed: Client requested an authorization id (%s) that is different from the token's principal name (%s)", authorizationId, token.principalName()));
        }
        this.tokenForNegotiatedProperty = token;
        this.complete = true;
        if (log.isDebugEnabled()) {
            log.debug("Successfully authenticate User={}", (Object)token.principalName());
        }
        return new byte[0];
    }

    private static String jsonErrorResponse(String errorStatus, String errorScope, String errorOpenIDConfiguration) {
        String jsonErrorResponse = String.format("{\"status\":\"%s\"", errorStatus);
        if (errorScope != null) {
            jsonErrorResponse = String.format("%s, \"scope\":\"%s\"", jsonErrorResponse, errorScope);
        }
        if (errorOpenIDConfiguration != null) {
            jsonErrorResponse = String.format("%s, \"openid-configuration\":\"%s\"", jsonErrorResponse, errorOpenIDConfiguration);
        }
        jsonErrorResponse = String.format("%s}", jsonErrorResponse);
        return jsonErrorResponse;
    }
}

