/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security.oauth;

import io.streamnative.pulsar.handlers.kop.security.oauth.KopOAuthBearerUnsecuredJws;
import io.streamnative.pulsar.handlers.kop.security.oauth.KopOAuthBearerValidatorCallback;
import io.streamnative.pulsar.handlers.kop.security.oauth.OAuthTokenDecoder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerScopeUtils;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationResult;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationUtils;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KopOAuthBearerUnsecuredValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(KopOAuthBearerUnsecuredValidatorCallbackHandler.class);
    private static final String OPTION_PREFIX = "unsecuredValidator";
    private static final String PRINCIPAL_CLAIM_NAME_OPTION = "unsecuredValidatorPrincipalClaimName";
    private static final String SCOPE_CLAIM_NAME_OPTION = "unsecuredValidatorScopeClaimName";
    private static final String REQUIRED_SCOPE_OPTION = "unsecuredValidatorRequiredScope";
    private static final String ALLOWABLE_CLOCK_SKEW_MILLIS_OPTION = "unsecuredValidatorAllowableClockSkewMs";
    private Time time = Time.SYSTEM;
    private Map<String, String> moduleOptions = null;
    private boolean configured = false;

    void time(Time time) {
        this.time = Objects.requireNonNull(time);
    }

    public boolean configured() {
        return this.configured;
    }

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        Map<String, ?> unmodifiableModuleOptions = Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
        this.moduleOptions = unmodifiableModuleOptions;
        this.configured = true;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof KopOAuthBearerValidatorCallback) {
                KopOAuthBearerValidatorCallback validationCallback = (KopOAuthBearerValidatorCallback)callback;
                try {
                    this.handleCallback(validationCallback);
                }
                catch (OAuthBearerIllegalTokenException e) {
                    OAuthBearerValidationResult failureReason = e.reason();
                    String failureScope = failureReason.failureScope();
                    validationCallback.error(failureScope != null ? "insufficient_scope" : "invalid_token", failureScope, failureReason.failureOpenIdConfig());
                }
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
    }

    private void handleCallback(KopOAuthBearerValidatorCallback callback) {
        String tokenValue = callback.tokenValue();
        if (tokenValue == null) {
            throw new IllegalArgumentException("Callback missing required token value");
        }
        String principalClaimName = this.principalClaimName();
        String scopeClaimName = this.scopeClaimName();
        List<String> requiredScope = this.requiredScope();
        int allowableClockSkewMs = this.allowableClockSkewMs();
        Pair<String, String> tokenAndTenant = OAuthTokenDecoder.decode(tokenValue);
        String token = (String)tokenAndTenant.getLeft();
        String tenant = (String)tokenAndTenant.getRight();
        KopOAuthBearerUnsecuredJws unsecuredJwt = new KopOAuthBearerUnsecuredJws(token, tenant, principalClaimName, scopeClaimName);
        long now = this.time.milliseconds();
        OAuthBearerValidationUtils.validateClaimForExistenceAndType((OAuthBearerUnsecuredJws)unsecuredJwt, (boolean)true, (String)principalClaimName, (Class[])new Class[]{String.class}).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateIssuedAt((OAuthBearerUnsecuredJws)unsecuredJwt, (boolean)false, (long)now, (int)allowableClockSkewMs).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateExpirationTime((OAuthBearerUnsecuredJws)unsecuredJwt, (long)now, (int)allowableClockSkewMs).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateTimeConsistency((OAuthBearerUnsecuredJws)unsecuredJwt).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateScope((OAuthBearerToken)unsecuredJwt, requiredScope).throwExceptionIfFailed();
        log.info("Successfully validated token with principal {}: {}", (Object)unsecuredJwt.principalName(), (Object)unsecuredJwt.claims().toString());
        callback.token(unsecuredJwt);
    }

    private String principalClaimName() {
        String principalClaimNameValue = this.option(PRINCIPAL_CLAIM_NAME_OPTION);
        return principalClaimNameValue != null && !principalClaimNameValue.trim().isEmpty() ? principalClaimNameValue.trim() : "sub";
    }

    private String scopeClaimName() {
        String scopeClaimNameValue = this.option(SCOPE_CLAIM_NAME_OPTION);
        return scopeClaimNameValue != null && !scopeClaimNameValue.trim().isEmpty() ? scopeClaimNameValue.trim() : "scope";
    }

    private List<String> requiredScope() {
        String requiredSpaceDelimitedScope = this.option(REQUIRED_SCOPE_OPTION);
        return requiredSpaceDelimitedScope == null || requiredSpaceDelimitedScope.trim().isEmpty() ? Collections.emptyList() : OAuthBearerScopeUtils.parseScope((String)requiredSpaceDelimitedScope.trim());
    }

    private int allowableClockSkewMs() {
        String allowableClockSkewMsValue = this.option(ALLOWABLE_CLOCK_SKEW_MILLIS_OPTION);
        int allowableClockSkewMs = 0;
        try {
            allowableClockSkewMs = allowableClockSkewMsValue == null || allowableClockSkewMsValue.trim().isEmpty() ? 0 : Integer.parseInt(allowableClockSkewMsValue.trim());
        }
        catch (NumberFormatException e) {
            throw new OAuthBearerConfigException(e.getMessage(), (Throwable)e);
        }
        if (allowableClockSkewMs < 0) {
            throw new OAuthBearerConfigException(String.format("Allowable clock skew millis must not be negative: %s", allowableClockSkewMsValue));
        }
        return allowableClockSkewMs;
    }

    private String option(String key) {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        return this.moduleOptions.get(Objects.requireNonNull(key));
    }
}

