/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security.oauth;

import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public class OAuthTokenDecoder {
    protected static final String DELIMITER = "__with_tenant_";

    public static Pair<String, String> decode(@NonNull String rawToken) {
        String tenant;
        String token;
        if (rawToken == null) {
            throw new NullPointerException("rawToken is marked non-null but is null");
        }
        int idx = rawToken.indexOf(DELIMITER);
        if (idx != -1) {
            token = rawToken.substring(idx + DELIMITER.length());
            tenant = rawToken.substring(0, idx);
        } else {
            token = rawToken;
            tenant = null;
        }
        return Pair.of((Object)token, tenant);
    }
}

