/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.security.oauth;

import com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsar.handlers.kop.security.oauth.KopOAuthBearerToken;
import io.streamnative.pulsar.handlers.kop.security.oauth.KopOAuthBearerValidatorCallback;
import io.streamnative.pulsar.handlers.kop.security.oauth.OAuthTokenDecoder;
import io.streamnative.pulsar.handlers.kop.security.oauth.ServerConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationResult;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(OauthValidatorCallbackHandler.class);
    private static final String DELIMITER = "__with_tenant_";
    private ServerConfig config = null;
    private AuthenticationService authenticationService;

    public OauthValidatorCallbackHandler() {
    }

    @VisibleForTesting
    protected OauthValidatorCallbackHandler(ServerConfig config, AuthenticationService authenticationService) {
        this.config = config;
        this.authenticationService = authenticationService;
    }

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        Map<String, String> options = jaasConfigEntries.get(0).getOptions();
        if (options == null) {
            throw new IllegalArgumentException("JAAS configuration options is null");
        }
        if (configs == null || configs.isEmpty() || !configs.containsKey("authenticationServerObj")) {
            throw new IllegalArgumentException("Configs map do not contains AuthenticationService.");
        }
        this.authenticationService = (AuthenticationService)configs.get("authenticationServerObj");
        this.config = new ServerConfig(options);
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof KopOAuthBearerValidatorCallback) {
                KopOAuthBearerValidatorCallback validatorCallback = (KopOAuthBearerValidatorCallback)callback;
                try {
                    this.handleCallback(validatorCallback);
                }
                catch (OAuthBearerIllegalTokenException e) {
                    OAuthBearerValidationResult failureReason = e.reason();
                    String failureScope = failureReason.failureScope();
                    validatorCallback.error(failureScope != null ? "insufficient_scope" : "invalid_token", failureScope, failureReason.failureOpenIdConfig());
                }
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @VisibleForTesting
    protected void handleCallback(KopOAuthBearerValidatorCallback callback) {
        if (callback.tokenValue() == null) {
            throw new IllegalArgumentException("Callback has null token value!");
        }
        if (this.authenticationService == null) {
            throw new IllegalStateException("AuthenticationService is null during token validation");
        }
        AuthenticationProvider authenticationProvider = this.authenticationService.getAuthenticationProvider(this.config.getValidateMethod());
        if (authenticationProvider == null) {
            throw new IllegalStateException("No AuthenticationProvider found for method " + this.config.getValidateMethod());
        }
        String tokenWithTenant = callback.tokenValue();
        Pair<String, String> tokenAndTenant = OAuthTokenDecoder.decode(tokenWithTenant);
        final String token = (String)tokenAndTenant.getLeft();
        final String tenant = (String)tokenAndTenant.getRight();
        try {
            AuthenticationState authState = authenticationProvider.newAuthState(AuthData.of((byte[])token.getBytes(StandardCharsets.UTF_8)), null, null);
            final String role = authState.getAuthRole();
            final AuthenticationDataSource authDataSource = authState.getAuthDataSource();
            callback.token(new KopOAuthBearerToken(){

                public String value() {
                    return token;
                }

                public Set<String> scope() {
                    return null;
                }

                public long lifetimeMs() {
                    return Long.MAX_VALUE;
                }

                public String principalName() {
                    return role;
                }

                @Override
                public AuthenticationDataSource authDataSource() {
                    return authDataSource;
                }

                @Override
                public String tenant() {
                    return tenant;
                }

                public Long startTimeMs() {
                    return Long.MAX_VALUE;
                }
            });
        }
        catch (AuthenticationException e) {
            log.error("OAuth validator callback handler new auth state failed: ", (Throwable)e);
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure((String)e.getMessage()));
        }
    }
}

