/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.stats;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import com.yahoo.sketches.quantiles.DoublesUnion;
import java.util.concurrent.locks.StampedLock;

public class LocalData {
    private final DoublesSketch successSketch = new DoublesSketchBuilder().build();
    private final DoublesSketch failSketch = new DoublesSketchBuilder().build();
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSuccessSketch(double value) {
        long stamp = this.lock.readLock();
        try {
            this.successSketch.update(value);
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFailedSketch(double value) {
        long stamp = this.lock.readLock();
        try {
            this.failSketch.update(value);
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(DoublesUnion aggregateSuccess, DoublesUnion aggregateFail) {
        long stamp = this.lock.writeLock();
        try {
            aggregateSuccess.update(this.successSketch);
            this.successSketch.reset();
            aggregateFail.update(this.failSketch);
            this.failSketch.reset();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

