/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.stats;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.streamnative.pulsar.handlers.kop.stats.DataSketchesOpStatsLogger;
import io.streamnative.pulsar.handlers.kop.stats.LongAdderCounter;
import io.streamnative.pulsar.handlers.kop.stats.PrometheusStatsLogger;
import io.streamnative.pulsar.handlers.kop.stats.PrometheusTextFormatUtil;
import io.streamnative.pulsar.handlers.kop.stats.ScopeContext;
import io.streamnative.pulsar.handlers.kop.stats.SimpleGauge;
import io.streamnative.pulsar.handlers.kop.stats.StatsLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

public class PrometheusMetricsProvider
implements PrometheusRawMetricsProvider {
    private ScheduledExecutorService executor;
    public static final String PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = "prometheusStatsLatencyRolloverSeconds";
    public static final int DEFAULT_PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = 60;
    private static final String KOP_PROMETHEUS_STATS_CLUSTER = "cluster";
    private final Map<String, String> defaultStatsLoggerLabels = new HashMap<String, String>();
    private final CollectorRegistry registry;
    public final ConcurrentMap<ScopeContext, LongAdderCounter> counters = new ConcurrentHashMap<ScopeContext, LongAdderCounter>();
    public final ConcurrentMap<ScopeContext, SimpleGauge<? extends Number>> gauges = new ConcurrentHashMap<ScopeContext, SimpleGauge<? extends Number>>();
    public final ConcurrentMap<ScopeContext, DataSketchesOpStatsLogger> opStats = new ConcurrentHashMap<ScopeContext, DataSketchesOpStatsLogger>();

    public PrometheusMetricsProvider() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMetricsProvider(CollectorRegistry registry) {
        this.registry = registry;
    }

    public void start(Configuration conf) {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("metrics"));
        int latencyRolloverSeconds = conf.getInt(PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS, 60);
        this.defaultStatsLoggerLabels.putIfAbsent(KOP_PROMETHEUS_STATS_CLUSTER, conf.getString(KOP_PROMETHEUS_STATS_CLUSTER));
        this.executor.scheduleAtFixedRate(() -> this.rotateLatencyCollection(), 1L, latencyRolloverSeconds, TimeUnit.SECONDS);
    }

    public void stop() {
        this.executor.shutdown();
    }

    public StatsLogger getStatsLogger(String scope) {
        return new PrometheusStatsLogger(this, scope, this.defaultStatsLoggerLabels);
    }

    public void generate(SimpleTextOutputStream writer) {
        this.gauges.forEach((sc, gauge) -> PrometheusTextFormatUtil.writeGauge(writer, sc.getScope(), gauge));
        this.counters.forEach((sc, counter) -> PrometheusTextFormatUtil.writeCounter(writer, sc.getScope(), counter));
        this.opStats.forEach((sc, opStatLogger) -> PrometheusTextFormatUtil.writeOpStat(writer, sc.getScope(), opStatLogger));
    }

    public String getStatsName(String ... statsComponents) {
        if (statsComponents.length == 0) {
            return "";
        }
        String completeName = statsComponents[0].isEmpty() ? StringUtils.join((Object[])statsComponents, (char)'_', (int)1, (int)statsComponents.length) : StringUtils.join((Object[])statsComponents, (char)'_');
        return Collector.sanitizeMetricName((String)completeName);
    }

    @VisibleForTesting
    void rotateLatencyCollection() {
        this.opStats.forEach((name, metric) -> metric.rotateLatencyCollection());
    }
}

