/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.stats;

import com.google.common.base.Joiner;
import io.prometheus.client.Collector;
import io.streamnative.pulsar.handlers.kop.stats.DataSketchesOpStatsLogger;
import io.streamnative.pulsar.handlers.kop.stats.LongAdderCounter;
import io.streamnative.pulsar.handlers.kop.stats.PrometheusMetricsProvider;
import io.streamnative.pulsar.handlers.kop.stats.ScopeContext;
import io.streamnative.pulsar.handlers.kop.stats.SimpleGauge;
import io.streamnative.pulsar.handlers.kop.stats.StatsLogger;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;

public class PrometheusStatsLogger
implements StatsLogger {
    private final PrometheusMetricsProvider provider;
    private final String scope;
    private final Map<String, String> labels;
    private final Map<String, String> completeNameCache = new ConcurrentHashMap<String, String>();
    private final Map<String, ScopeContext> scopeContextCache = new ConcurrentHashMap<String, ScopeContext>();

    PrometheusStatsLogger(PrometheusMetricsProvider provider, String scope, Map<String, String> labels) {
        this.provider = provider;
        this.scope = scope;
        this.labels = labels;
    }

    @Override
    public OpStatsLogger getOpStatsLogger(String name) {
        return this.provider.opStats.computeIfAbsent(this.scopeContext(name), x -> new DataSketchesOpStatsLogger(this.labels));
    }

    @Override
    public Counter getCounter(String name) {
        return this.provider.counters.computeIfAbsent(this.scopeContext(name), x -> new LongAdderCounter(this.labels));
    }

    @Override
    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.provider.gauges.computeIfAbsent(this.scopeContext(name), x -> new SimpleGauge(gauge, this.labels));
    }

    @Override
    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    @Override
    public void removeScope(String name, StatsLogger statsLogger) {
    }

    @Override
    public StatsLogger scope(String name) {
        return new PrometheusStatsLogger(this.provider, this.completeName(name), this.labels);
    }

    @Override
    public StatsLogger scopeLabel(String labelName, String labelValue) {
        TreeMap<String, String> newLabels = new TreeMap<String, String>(this.labels);
        newLabels.put(labelName, labelValue);
        return new PrometheusStatsLogger(this.provider, this.scope, newLabels);
    }

    private ScopeContext scopeContext(String name) {
        return this.scopeContextCache.computeIfAbsent(name, __ -> new ScopeContext(this.completeName(name), this.labels));
    }

    private String completeName(String name) {
        return this.completeNameCache.computeIfAbsent(name, __ -> Collector.sanitizeMetricName((String)(this.scope.isEmpty() ? name : Joiner.on((char)'_').join((Object)this.scope, (Object)name, new Object[0]))));
    }
}

