/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.stats;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.streamnative.pulsar.handlers.kop.stats.DataSketchesOpStatsLogger;
import io.streamnative.pulsar.handlers.kop.stats.LongAdderCounter;
import io.streamnative.pulsar.handlers.kop.stats.SimpleGauge;
import java.util.Enumeration;
import java.util.Map;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

public class PrometheusTextFormatUtil {
    public static void writeGauge(SimpleTextOutputStream w, String name, SimpleGauge<? extends Number> gauge) {
        w.write("# TYPE ").write(name).write(" gauge\n");
        w.write(name);
        PrometheusTextFormatUtil.writeLabels(w, gauge.getLabels());
        w.write(' ').write(gauge.getSample().toString()).write('\n');
    }

    public static void writeCounter(SimpleTextOutputStream w, String name, LongAdderCounter counter) {
        w.write("# TYPE ").write(name).write(" counter\n");
        w.write(name);
        PrometheusTextFormatUtil.writeLabels(w, counter.getLabels());
        w.write(' ').write(counter.get().toString()).write('\n');
    }

    public static void writeOpStat(SimpleTextOutputStream w, String name, DataSketchesOpStatsLogger opStat) {
        w.write("# TYPE ").write(name).write(" summary\n");
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 0.5);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 0.75);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 0.95);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 0.99);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 0.999);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 0.9999);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, false, 1.0);
        PrometheusTextFormatUtil.writeCount(w, opStat, name, false);
        PrometheusTextFormatUtil.writeSum(w, opStat, name, false);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 0.5);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 0.75);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 0.95);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 0.99);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 0.999);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 0.9999);
        PrometheusTextFormatUtil.writeQuantile(w, opStat, name, true, 1.0);
        PrometheusTextFormatUtil.writeCount(w, opStat, name, true);
        PrometheusTextFormatUtil.writeSum(w, opStat, name, true);
    }

    private static void writeQuantile(SimpleTextOutputStream w, DataSketchesOpStatsLogger opStat, String name, boolean success, double quantile) {
        w.write(name).write("{success=\"").write(success).write("\",quantile=\"").write(Double.toString(quantile));
        if (!opStat.getLabels().isEmpty()) {
            w.write("\", ");
            PrometheusTextFormatUtil.writeLabelsNoBraces(w, opStat.getLabels());
        } else {
            w.write("\"");
        }
        w.write("} ").write(Double.toString(opStat.getQuantileValue(success, quantile))).write('\n');
    }

    private static void writeCount(SimpleTextOutputStream w, DataSketchesOpStatsLogger opStat, String name, boolean success) {
        w.write(name).write("_count{success=\"").write(success);
        if (!opStat.getLabels().isEmpty()) {
            w.write("\", ");
            PrometheusTextFormatUtil.writeLabelsNoBraces(w, opStat.getLabels());
        } else {
            w.write("\"");
        }
        w.write("} ").write(Long.toString(opStat.getCount(success))).write('\n');
    }

    private static void writeSum(SimpleTextOutputStream w, DataSketchesOpStatsLogger opStat, String name, boolean success) {
        w.write(name).write("_sum{success=\"").write(success);
        if (!opStat.getLabels().isEmpty()) {
            w.write("\", ");
            PrometheusTextFormatUtil.writeLabelsNoBraces(w, opStat.getLabels());
        } else {
            w.write("\"");
        }
        w.write("} ").write(Double.toString(opStat.getSum(success))).write('\n');
    }

    public static void writeMetricsCollectedByPrometheusClient(SimpleTextOutputStream w, CollectorRegistry registry) {
        Enumeration metricFamilySamples = registry.metricFamilySamples();
        while (metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamily = (Collector.MetricFamilySamples)metricFamilySamples.nextElement();
            for (int i = 0; i < metricFamily.samples.size(); ++i) {
                Collector.MetricFamilySamples.Sample sample = (Collector.MetricFamilySamples.Sample)metricFamily.samples.get(i);
                w.write(sample.name);
                w.write('{');
                for (int j = 0; j < sample.labelNames.size(); ++j) {
                    if (j != 0) {
                        w.write(", ");
                    }
                    w.write((String)sample.labelNames.get(j));
                    w.write("=\"");
                    w.write((String)sample.labelValues.get(j));
                    w.write('\"');
                }
                w.write("} ");
                w.write(Collector.doubleToGoString((double)sample.value));
                w.write('\n');
            }
        }
    }

    private static void writeLabels(SimpleTextOutputStream w, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return;
        }
        w.write('{');
        PrometheusTextFormatUtil.writeLabelsNoBraces(w, labels);
        w.write('}');
    }

    private static void writeLabelsNoBraces(SimpleTextOutputStream w, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> e : labels.entrySet()) {
            if (!isFirst) {
                w.write(',');
            }
            isFirst = false;
            w.write(e.getKey()).write("=\"").write(e.getValue()).write('\"');
        }
    }
}

