/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.storage;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Recycler;
import io.streamnative.pulsar.handlers.kop.KafkaTopicManager;
import io.streamnative.pulsar.handlers.kop.PendingTopicFutures;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;

public class AppendRecordsContext {
    private static final Recycler<AppendRecordsContext> RECYCLER = new Recycler<AppendRecordsContext>(){

        protected AppendRecordsContext newObject(Recycler.Handle<AppendRecordsContext> handle) {
            return new AppendRecordsContext(handle);
        }
    };
    private final Recycler.Handle<AppendRecordsContext> recyclerHandle;
    private KafkaTopicManager topicManager;
    private Consumer<Integer> startSendOperationForThrottling;
    private Consumer<Integer> completeSendOperationForThrottling;
    private Map<TopicPartition, PendingTopicFutures> pendingTopicFuturesMap;
    private ChannelHandlerContext ctx;

    private AppendRecordsContext(Recycler.Handle<AppendRecordsContext> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public static AppendRecordsContext get(KafkaTopicManager topicManager, Consumer<Integer> startSendOperationForThrottling, Consumer<Integer> completeSendOperationForThrottling, Map<TopicPartition, PendingTopicFutures> pendingTopicFuturesMap, ChannelHandlerContext ctx) {
        AppendRecordsContext context = (AppendRecordsContext)RECYCLER.get();
        context.topicManager = topicManager;
        context.startSendOperationForThrottling = startSendOperationForThrottling;
        context.completeSendOperationForThrottling = completeSendOperationForThrottling;
        context.pendingTopicFuturesMap = pendingTopicFuturesMap;
        context.ctx = ctx;
        return context;
    }

    public void recycle() {
        this.topicManager = null;
        this.startSendOperationForThrottling = null;
        this.completeSendOperationForThrottling = null;
        this.pendingTopicFuturesMap = null;
        this.recyclerHandle.recycle((Object)this);
        this.ctx = null;
    }

    public Recycler.Handle<AppendRecordsContext> getRecyclerHandle() {
        return this.recyclerHandle;
    }

    public KafkaTopicManager getTopicManager() {
        return this.topicManager;
    }

    public Consumer<Integer> getStartSendOperationForThrottling() {
        return this.startSendOperationForThrottling;
    }

    public Consumer<Integer> getCompleteSendOperationForThrottling() {
        return this.completeSendOperationForThrottling;
    }

    public Map<TopicPartition, PendingTopicFutures> getPendingTopicFuturesMap() {
        return this.pendingTopicFuturesMap;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }
}

