/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import io.streamnative.pulsar.handlers.kop.RequestStats;
import io.streamnative.pulsar.handlers.kop.storage.PartitionLog;
import io.streamnative.pulsar.handlers.kop.storage.ProducerStateManager;
import io.streamnative.pulsar.handlers.kop.utils.KopTopic;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.pulsar.broker.service.plugin.EntryFilterWithClassLoader;

public class PartitionLogManager {
    private final KafkaServiceConfiguration kafkaConfig;
    private final RequestStats requestStats;
    private final Map<String, PartitionLog> logMap;
    private final Time time;
    private final ImmutableMap<String, EntryFilterWithClassLoader> entryfilterMap;

    public PartitionLogManager(KafkaServiceConfiguration kafkaConfig, RequestStats requestStats, ImmutableMap<String, EntryFilterWithClassLoader> entryfilterMap, Time time) {
        this.kafkaConfig = kafkaConfig;
        this.requestStats = requestStats;
        this.logMap = Maps.newConcurrentMap();
        this.entryfilterMap = entryfilterMap;
        this.time = time;
    }

    public PartitionLog getLog(TopicPartition topicPartition, String namespacePrefix) {
        String kopTopic = KopTopic.toString(topicPartition, namespacePrefix);
        return this.logMap.computeIfAbsent(kopTopic, key -> new PartitionLog(this.kafkaConfig, this.requestStats, this.time, topicPartition, kopTopic, this.entryfilterMap, new ProducerStateManager(kopTopic)));
    }

    public PartitionLog removeLog(String topicName) {
        return this.logMap.remove(topicName);
    }

    public int size() {
        return this.logMap.size();
    }

    public PartitionLogManager(KafkaServiceConfiguration kafkaConfig, RequestStats requestStats, Map<String, PartitionLog> logMap, Time time, ImmutableMap<String, EntryFilterWithClassLoader> entryfilterMap) {
        this.kafkaConfig = kafkaConfig;
        this.requestStats = requestStats;
        this.logMap = logMap;
        this.time = time;
        this.entryfilterMap = entryfilterMap;
    }
}

