/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.storage;

import io.streamnative.pulsar.handlers.kop.storage.CompletedTxn;
import io.streamnative.pulsar.handlers.kop.storage.PartitionLog;
import io.streamnative.pulsar.handlers.kop.storage.ProducerStateEntry;
import io.streamnative.pulsar.handlers.kop.storage.TxnMetadata;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerAppendInfo {
    private static final Logger log = LoggerFactory.getLogger(ProducerAppendInfo.class);
    private final String topicPartition;
    private final Long producerId;
    private final ProducerStateEntry currentEntry;
    private final PartitionLog.AppendOrigin origin;
    private final List<TxnMetadata> transactions = Lists.newArrayList();
    private ProducerStateEntry updatedEntry;

    public ProducerAppendInfo(String topicPartition, Long producerId, ProducerStateEntry currentEntry, PartitionLog.AppendOrigin origin) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.origin = origin;
        this.initUpdatedEntry();
    }

    private void checkProducerEpoch(Short producerEpoch) {
        if (producerEpoch < this.updatedEntry.producerEpoch()) {
            String message = String.format("Producer's epoch in %s is %s, which is smaller than the last seen epoch %s", this.topicPartition, producerEpoch, this.currentEntry.producerEpoch());
            throw new IllegalArgumentException(message);
        }
    }

    public Optional<CompletedTxn> append(RecordBatch batch, Optional<Long> firstOffset) {
        if (log.isDebugEnabled()) {
            log.debug("Append batch: pid: {} firstOffset {} baseSequence: {} lastSequence: {} baseOffset: {}  lastOffset: {} ", new Object[]{batch.producerId(), firstOffset, batch.baseSequence(), batch.lastSequence(), batch.baseOffset(), batch.lastOffset()});
        }
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                return this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
            }
            return Optional.empty();
        }
        this.updateCurrentTxnFirstOffset(batch.isTransactional(), firstOffset.orElse(batch.baseOffset()));
        return Optional.empty();
    }

    public void updateCurrentTxnFirstOffset(Boolean isTransactional, long firstOffset) {
        if (this.updatedEntry.currentTxnFirstOffset().isPresent()) {
            if (!isTransactional.booleanValue()) {
                String msg = String.format("Expected transactional write from producer %s at offset %s in partition %s", this.producerId, firstOffset, this.topicPartition);
                throw new InvalidTxnStateException(msg);
            }
        } else if (isTransactional.booleanValue()) {
            this.updatedEntry.currentTxnFirstOffset(Optional.of(firstOffset));
            this.transactions.add(new TxnMetadata(this.producerId, firstOffset));
        }
    }

    public Optional<CompletedTxn> appendEndTxnMarker(EndTransactionMarker endTxnMarker, Short producerEpoch, Long offset, Long timestamp) {
        this.checkProducerEpoch(producerEpoch);
        Optional<CompletedTxn> completedTxn = this.updatedEntry.currentTxnFirstOffset().map(firstOffset -> new CompletedTxn(this.producerId, (Long)firstOffset, offset, endTxnMarker.controlType() == ControlRecordType.ABORT));
        this.updatedEntry.maybeUpdateProducerEpoch(producerEpoch);
        this.updatedEntry.currentTxnFirstOffset(Optional.empty());
        this.updatedEntry.lastTimestamp(timestamp);
        return completedTxn;
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry;
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions;
    }

    private void initUpdatedEntry() {
        this.updatedEntry = ProducerStateEntry.empty(this.producerId);
        this.updatedEntry.producerEpoch(this.currentEntry.producerEpoch());
        this.updatedEntry.coordinatorEpoch(this.currentEntry.coordinatorEpoch());
        this.updatedEntry.lastTimestamp(this.currentEntry.lastTimestamp());
        this.updatedEntry.currentTxnFirstOffset(this.currentEntry.currentTxnFirstOffset());
    }

    public String topicPartition() {
        return this.topicPartition;
    }

    public Long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public PartitionLog.AppendOrigin origin() {
        return this.origin;
    }

    public List<TxnMetadata> transactions() {
        return this.transactions;
    }

    public ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    public ProducerAppendInfo updatedEntry(ProducerStateEntry updatedEntry) {
        this.updatedEntry = updatedEntry;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerAppendInfo)) {
            return false;
        }
        ProducerAppendInfo other = (ProducerAppendInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$producerId = this.producerId();
        Long other$producerId = other.producerId();
        if (this$producerId == null ? other$producerId != null : !((Object)this$producerId).equals(other$producerId)) {
            return false;
        }
        String this$topicPartition = this.topicPartition();
        String other$topicPartition = other.topicPartition();
        if (this$topicPartition == null ? other$topicPartition != null : !this$topicPartition.equals(other$topicPartition)) {
            return false;
        }
        ProducerStateEntry this$currentEntry = this.currentEntry();
        ProducerStateEntry other$currentEntry = other.currentEntry();
        if (this$currentEntry == null ? other$currentEntry != null : !((Object)this$currentEntry).equals(other$currentEntry)) {
            return false;
        }
        PartitionLog.AppendOrigin this$origin = this.origin();
        PartitionLog.AppendOrigin other$origin = other.origin();
        if (this$origin == null ? other$origin != null : !((Object)((Object)this$origin)).equals((Object)other$origin)) {
            return false;
        }
        List<TxnMetadata> this$transactions = this.transactions();
        List<TxnMetadata> other$transactions = other.transactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        ProducerStateEntry this$updatedEntry = this.updatedEntry();
        ProducerStateEntry other$updatedEntry = other.updatedEntry();
        return !(this$updatedEntry == null ? other$updatedEntry != null : !((Object)this$updatedEntry).equals(other$updatedEntry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProducerAppendInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $producerId = this.producerId();
        result = result * 59 + ($producerId == null ? 43 : ((Object)$producerId).hashCode());
        String $topicPartition = this.topicPartition();
        result = result * 59 + ($topicPartition == null ? 43 : $topicPartition.hashCode());
        ProducerStateEntry $currentEntry = this.currentEntry();
        result = result * 59 + ($currentEntry == null ? 43 : ((Object)$currentEntry).hashCode());
        PartitionLog.AppendOrigin $origin = this.origin();
        result = result * 59 + ($origin == null ? 43 : ((Object)((Object)$origin)).hashCode());
        List<TxnMetadata> $transactions = this.transactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        ProducerStateEntry $updatedEntry = this.updatedEntry();
        result = result * 59 + ($updatedEntry == null ? 43 : ((Object)$updatedEntry).hashCode());
        return result;
    }

    public String toString() {
        return "ProducerAppendInfo(topicPartition=" + this.topicPartition() + ", producerId=" + this.producerId() + ", currentEntry=" + this.currentEntry() + ", origin=" + this.origin() + ", transactions=" + this.transactions() + ", updatedEntry=" + this.updatedEntry() + ")";
    }
}

